/*
 * Decompiled with CFR 0.152.
 */
package example.bluetooth.demo;

import example.bluetooth.demo.GUIImageServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.DataElement;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

final class BTImageServer
implements Runnable {
    private static final UUID PICTURES_SERVER_UUID = new UUID("F0E0D0C0B0A000908070605040302010", false);
    private static final int IMAGES_NAMES_ATTRIBUTE_ID = 17185;
    private LocalDevice localDevice;
    private StreamConnectionNotifier notifier;
    private ServiceRecord record;
    private GUIImageServer parent;
    private boolean isClosed;
    private Thread accepterThread;
    private ClientProcessor processor;
    private final Hashtable dataElements = new Hashtable();

    BTImageServer(GUIImageServer gUIImageServer) {
        this.parent = gUIImageServer;
        this.accepterThread = new Thread(this);
        this.accepterThread.start();
    }

    public void run() {
        StringBuffer stringBuffer;
        boolean bl = false;
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            if (!this.localDevice.setDiscoverable(10390323)) {
                // empty if block
            }
            stringBuffer = new StringBuffer("btspp://");
            stringBuffer.append("localhost").append(':');
            stringBuffer.append(PICTURES_SERVER_UUID.toString());
            stringBuffer.append(";name=Picture Server");
            stringBuffer.append(";authorize=false");
            this.notifier = (StreamConnectionNotifier)Connector.open((String)stringBuffer.toString());
            this.record = this.localDevice.getRecord((Connection)this.notifier);
            DataElement dataElement = new DataElement(48);
            this.record.setAttributeValue(17185, dataElement);
            bl = true;
        }
        catch (Exception exception) {
            System.err.println("Can't initialize bluetooth: " + exception);
        }
        this.parent.completeInitialization(bl);
        if (!bl) {
            return;
        }
        this.processor = new ClientProcessor();
        while (!this.isClosed) {
            stringBuffer = null;
            try {
                stringBuffer = this.notifier.acceptAndOpen();
            }
            catch (IOException iOException) {
                continue;
            }
            this.processor.addConnection((StreamConnection)stringBuffer);
        }
    }

    boolean changeImageInfo(String string, boolean bl) {
        DataElement dataElement = this.record.getAttributeValue(17185);
        DataElement dataElement2 = (DataElement)this.dataElements.get(string);
        if (dataElement2 == null) {
            dataElement2 = new DataElement(32, (Object)string);
            this.dataElements.put(string, dataElement2);
        }
        if (bl) {
            dataElement.addElement(dataElement2);
        } else if (!dataElement.removeElement(dataElement2)) {
            System.err.println("Error: item was not removed for: " + string);
            return false;
        }
        this.record.setAttributeValue(17185, dataElement);
        try {
            this.localDevice.updateRecord(this.record);
        }
        catch (ServiceRegistrationException serviceRegistrationException) {
            System.err.println("Can't update record now for: " + string);
            return false;
        }
        return true;
    }

    void destroy() {
        this.isClosed = true;
        if (this.notifier != null) {
            try {
                this.notifier.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.accepterThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.processor != null) {
            this.processor.destroy(true);
        }
        this.processor = null;
    }

    private void processConnection(StreamConnection streamConnection) {
        String string = this.readImageName(streamConnection);
        string = this.parent.getImageFileName(string);
        byte[] byArray = this.getImageData(string);
        this.sendImageData(byArray, streamConnection);
        try {
            streamConnection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendImageData(byte[] byArray, StreamConnection streamConnection) {
        if (byArray == null) {
            return;
        }
        OutputStream outputStream = null;
        try {
            outputStream = streamConnection.openOutputStream();
            outputStream.write(byArray.length >> 8);
            outputStream.write(byArray.length & 0xFF);
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("Can't send image data: " + iOException);
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String readImageName(StreamConnection streamConnection) {
        String string = null;
        InputStream inputStream = null;
        try {
            int n;
            inputStream = streamConnection.openInputStream();
            int n2 = inputStream.read();
            if (n2 <= 0) {
                throw new IOException("Can't read name length");
            }
            byte[] byArray = new byte[n2];
            for (n2 = 0; n2 != byArray.length; n2 += n) {
                n = inputStream.read(byArray, n2, byArray.length - n2);
                if (n != -1) continue;
                throw new IOException("Can't read name data");
            }
            string = new String(byArray);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    private byte[] getImageData(String string) {
        if (string == null) {
            return null;
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            System.err.println("Can't get image data: imgName=" + string + " :" + iOException);
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private class ClientProcessor
    implements Runnable {
        private Thread processorThread;
        private Vector queue = new Vector();
        private boolean isOk = true;

        ClientProcessor() {
            this.processorThread = new Thread(this);
            this.processorThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!BTImageServer.this.isClosed) {
                ClientProcessor clientProcessor = this;
                synchronized (clientProcessor) {
                    if (this.queue.size() == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            System.err.println("Unexpected exception: " + interruptedException);
                            this.destroy(false);
                            return;
                        }
                    }
                }
                ClientProcessor clientProcessor2 = this;
                synchronized (clientProcessor2) {
                    if (BTImageServer.this.isClosed) {
                        return;
                    }
                    clientProcessor = (StreamConnection)this.queue.firstElement();
                    this.queue.removeElementAt(0);
                    BTImageServer.this.processConnection((StreamConnection)clientProcessor);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addConnection(StreamConnection streamConnection) {
            ClientProcessor clientProcessor = this;
            synchronized (clientProcessor) {
                this.queue.addElement(streamConnection);
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy(boolean bl) {
            ClientProcessor clientProcessor = this;
            synchronized (clientProcessor) {
                this.notify();
                while (this.queue.size() != 0) {
                    StreamConnection streamConnection = (StreamConnection)this.queue.firstElement();
                    this.queue.removeElementAt(0);
                    try {
                        streamConnection.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                this.processorThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

