/*
 * Decompiled with CFR 0.152.
 */
package example.bluetooth.demo;

import example.bluetooth.demo.BTImageClient;
import example.bluetooth.demo.DemoMIDlet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

final class GUIImageClient
implements CommandListener {
    private final Command SCR_MAIN_BACK_CMD = new Command("Back", 2, 2);
    private final Command SCR_MAIN_SEARCH_CMD = new Command("Find", 4, 1);
    private final Command SCR_SEARCH_CANCEL_CMD = new Command("Cancel", 2, 2);
    private final Command SCR_IMAGES_BACK_CMD = new Command("Back", 2, 2);
    private final Command SCR_IMAGES_LOAD_CMD = new Command("Load", 4, 1);
    private final Command SCR_LOAD_CANCEL_CMD = new Command("Cancel", 2, 2);
    private final Command SCR_SHOW_BACK_CMD = new Command("Back", 2, 2);
    private final Form mainScreen = new Form("Image Viewer");
    private final List listScreen = new List("Image Viewer", 3);
    private final Form imageScreen = new Form("Image Viewer");
    private DemoMIDlet parent;
    private BTImageClient bt_client;

    GUIImageClient(DemoMIDlet demoMIDlet) {
        this.parent = demoMIDlet;
        this.bt_client = new BTImageClient(this);
        this.mainScreen.addCommand(this.SCR_MAIN_BACK_CMD);
        this.mainScreen.addCommand(this.SCR_MAIN_SEARCH_CMD);
        this.mainScreen.setCommandListener((CommandListener)this);
        this.listScreen.addCommand(this.SCR_IMAGES_BACK_CMD);
        this.listScreen.addCommand(this.SCR_IMAGES_LOAD_CMD);
        this.listScreen.setCommandListener((CommandListener)this);
        this.imageScreen.addCommand(this.SCR_SHOW_BACK_CMD);
        this.imageScreen.setCommandListener((CommandListener)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.SCR_MAIN_BACK_CMD) {
            this.destroy();
            this.parent.show();
            return;
        }
        if (command == this.SCR_MAIN_SEARCH_CMD) {
            Form form = new Form("Searching...");
            form.addCommand(this.SCR_SEARCH_CANCEL_CMD);
            form.setCommandListener((CommandListener)this);
            form.append((Item)new Gauge("Searching images...", false, -1, 2));
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)form);
            this.bt_client.requestSearch();
            return;
        }
        if (command == this.SCR_SEARCH_CANCEL_CMD) {
            this.bt_client.cancelSearch();
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.mainScreen);
            return;
        }
        if (command == this.SCR_IMAGES_BACK_CMD) {
            this.bt_client.requestLoad(null);
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.mainScreen);
            return;
        }
        if (command == this.SCR_IMAGES_LOAD_CMD) {
            Form form = new Form("Loading...");
            form.addCommand(this.SCR_LOAD_CANCEL_CMD);
            form.setCommandListener((CommandListener)this);
            form.append((Item)new Gauge("Loading image...", false, -1, 2));
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)form);
            List list = (List)displayable;
            this.bt_client.requestLoad(list.getString(list.getSelectedIndex()));
            return;
        }
        if (command == this.SCR_LOAD_CANCEL_CMD) {
            this.bt_client.cancelLoad();
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.listScreen);
            return;
        }
        if (command == this.SCR_SHOW_BACK_CMD) {
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.listScreen);
            return;
        }
    }

    void completeInitialization(boolean bl) {
        if (bl) {
            StringItem stringItem = new StringItem("Ready for images search!", null);
            stringItem.setLayout(51);
            this.mainScreen.append((Item)stringItem);
            Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.mainScreen);
            return;
        }
        Alert alert = new Alert("Error", "Can't initialize bluetooth", null, AlertType.ERROR);
        alert.setTimeout(2000);
        Display.getDisplay((MIDlet)this.parent).setCurrent(alert, this.parent.getDisplayable());
    }

    void destroy() {
        this.bt_client.destroy();
    }

    void informSearchError(String string) {
        Alert alert = new Alert("Error", string, null, AlertType.ERROR);
        alert.setTimeout(2000);
        Display.getDisplay((MIDlet)this.parent).setCurrent(alert, (Displayable)this.mainScreen);
    }

    void informLoadError(String string) {
        Alert alert = new Alert("Error", string, null, AlertType.ERROR);
        alert.setTimeout(2000);
        Display.getDisplay((MIDlet)this.parent).setCurrent(alert, (Displayable)this.listScreen);
    }

    void showImage(Image image, String string) {
        this.imageScreen.deleteAll();
        this.imageScreen.append((Item)new ImageItem(string, image, 51, "Downloaded image: " + string));
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.imageScreen);
    }

    boolean showImagesNames(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        if (!enumeration.hasMoreElements()) {
            this.informSearchError("No images names in found services");
            return false;
        }
        while (this.listScreen.size() != 0) {
            this.listScreen.delete(0);
        }
        while (enumeration.hasMoreElements()) {
            this.listScreen.append((String)enumeration.nextElement(), null);
        }
        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.listScreen);
        return true;
    }
}

