/*
 * Decompiled with CFR 0.152.
 */
package example.pim;

import example.pim.ItemDisplayScreen;
import example.pim.PIMDemo;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.Event;
import javax.microedition.pim.EventList;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import javax.microedition.pim.ToDo;
import javax.microedition.pim.ToDoList;

public class ItemSelectionScreen
extends List
implements CommandListener {
    private final Command selectCommand = new Command("Select", 8, 1);
    private final Command backCommand = new Command("Back", 2, 1);
    private final Command removeCommand = new Command("Delete", 1, 3);
    private final Command newCommand = new Command("New", 1, 2);
    private final PIMDemo midlet;
    private final Displayable caller;
    private final int listType;
    private final PIMList list;
    private final Vector itemList = new Vector();

    public ItemSelectionScreen(PIMDemo pIMDemo, Displayable displayable, int n, PIMList pIMList) throws PIMException {
        super("Select a PIM item", 3);
        this.midlet = pIMDemo;
        this.caller = displayable;
        this.listType = n;
        this.list = pIMList;
        this.populateList();
        this.addCommand(this.backCommand);
        this.addCommand(this.newCommand);
        this.setCommandListener(this);
    }

    void populateList() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ItemSelectionScreen itemSelectionScreen = ItemSelectionScreen.this;
                synchronized (itemSelectionScreen) {
                    try {
                        ItemSelectionScreen.this.deleteAll();
                        ItemSelectionScreen.this.removeCommand(ItemSelectionScreen.this.selectCommand);
                        ItemSelectionScreen.this.removeCommand(ItemSelectionScreen.this.removeCommand);
                        ItemSelectionScreen.this.itemList.removeAllElements();
                        Enumeration enumeration = ItemSelectionScreen.this.list.items();
                        while (enumeration.hasMoreElements()) {
                            PIMItem pIMItem = (PIMItem)enumeration.nextElement();
                            int n = 0;
                            switch (ItemSelectionScreen.this.listType) {
                                case 1: {
                                    n = 105;
                                    break;
                                }
                                case 2: {
                                    n = 107;
                                    break;
                                }
                                case 3: {
                                    n = 107;
                                }
                            }
                            String string = ItemSelectionScreen.this.getDisplayedField(pIMItem);
                            if (string == null) {
                                string = "<Incomplete data>";
                            }
                            ItemSelectionScreen.this.append(string, null);
                            ItemSelectionScreen.this.itemList.addElement(pIMItem);
                        }
                        if (ItemSelectionScreen.this.size() > 0) {
                            ItemSelectionScreen.this.setSelectCommand(ItemSelectionScreen.this.selectCommand);
                            ItemSelectionScreen.this.addCommand(ItemSelectionScreen.this.removeCommand);
                        }
                    }
                    catch (PIMException pIMException) {
                        ItemSelectionScreen.this.midlet.reportException((Exception)((Object)pIMException), (Displayable)ItemSelectionScreen.this);
                    }
                }
            }
        }).start();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            Display.getDisplay((MIDlet)this.midlet).setCurrent(this.caller);
        } else if (command == this.selectCommand) {
            try {
                PIMItem pIMItem = (PIMItem)this.itemList.elementAt(this.getSelectedIndex());
                ItemDisplayScreen itemDisplayScreen = new ItemDisplayScreen(this.midlet, this, pIMItem);
                Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)itemDisplayScreen);
            }
            catch (Exception exception) {
                this.midlet.reportException(exception, (Displayable)this);
            }
        } else if (command == this.removeCommand) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ItemSelectionScreen itemSelectionScreen = ItemSelectionScreen.this;
                    synchronized (itemSelectionScreen) {
                        try {
                            PIMItem pIMItem = (PIMItem)ItemSelectionScreen.this.itemList.elementAt(ItemSelectionScreen.this.getSelectedIndex());
                            switch (ItemSelectionScreen.this.listType) {
                                case 1: {
                                    ((ContactList)ItemSelectionScreen.this.list).removeContact((Contact)pIMItem);
                                    break;
                                }
                                case 2: {
                                    ((EventList)ItemSelectionScreen.this.list).removeEvent((Event)pIMItem);
                                    break;
                                }
                                case 3: {
                                    ((ToDoList)ItemSelectionScreen.this.list).removeToDo((ToDo)pIMItem);
                                }
                            }
                        }
                        catch (Exception exception) {
                            ItemSelectionScreen.this.midlet.reportException(exception, (Displayable)ItemSelectionScreen.this);
                        }
                    }
                }
            }).start();
            this.populateList();
        } else if (command == this.newCommand) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Contact contact = null;
                        switch (ItemSelectionScreen.this.listType) {
                            case 1: {
                                contact = ((ContactList)ItemSelectionScreen.this.list).createContact();
                                break;
                            }
                            case 2: {
                                contact = ((EventList)ItemSelectionScreen.this.list).createEvent();
                                break;
                            }
                            case 3: {
                                contact = ((ToDoList)ItemSelectionScreen.this.list).createToDo();
                            }
                        }
                        int n = ItemSelectionScreen.this.getDisplayedFieldCode();
                        contact.addString(n, 0, "");
                        ItemDisplayScreen itemDisplayScreen = new ItemDisplayScreen(ItemSelectionScreen.this.midlet, ItemSelectionScreen.this, (PIMItem)contact);
                        Display.getDisplay((MIDlet)ItemSelectionScreen.this.midlet).setCurrent((Displayable)itemDisplayScreen);
                    }
                    catch (Exception exception) {
                        ItemSelectionScreen.this.midlet.reportException(exception, (Displayable)ItemSelectionScreen.this);
                    }
                }
            }).start();
        }
    }

    int getDisplayedFieldCode() {
        int n = 0;
        switch (this.listType) {
            case 1: {
                n = 105;
                break;
            }
            case 2: {
                n = 107;
                break;
            }
            case 3: {
                n = 107;
            }
        }
        return n;
    }

    void fixDisplayedField(PIMItem pIMItem) {
        int n = this.getDisplayedFieldCode();
        if (this.listType == 1) {
            String[] stringArray;
            boolean bl = false;
            if (pIMItem.countValues(n) != 0 && (stringArray = pIMItem.getString(n, 0)) != null && stringArray.trim().length() > 0) {
                bl = true;
            }
            if (!bl && pIMItem.countValues(106) != 0 && (stringArray = pIMItem.getStringArray(106, 0)) != null) {
                String string;
                StringBuffer stringBuffer = new StringBuffer();
                if (stringArray[1] != null) {
                    stringBuffer.append(stringArray[1]);
                }
                if (stringArray[0] != null) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(stringArray[0]);
                }
                if ((string = stringBuffer.toString().trim()).length() > 0) {
                    if (pIMItem.countValues(n) == 0) {
                        pIMItem.addString(n, 0, string);
                    } else {
                        pIMItem.setString(n, 0, 0, string);
                    }
                }
            }
        }
    }

    String getDisplayedField(PIMItem pIMItem) {
        String string;
        int n = this.getDisplayedFieldCode();
        this.fixDisplayedField(pIMItem);
        String string2 = null;
        if (pIMItem.countValues(n) != 0 && (string = pIMItem.getString(n, 0)) != null && string.trim().length() != 0) {
            string2 = string;
        }
        return string2;
    }
}

