/*
 * Decompiled with CFR 0.152.
 */
package tetris;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import tetris.DropThread;
import tetris.model.TetrisBoard;
import tetris.model.TetrisPiece;
import tetris.ui.TetrisCanvas;

public class TetrisMidlet
extends MIDlet
implements CommandListener {
    private TetrisCanvas gameCanvas;
    private TetrisBoard board;
    private TetrisPiece activePiece;
    private int score;
    private int level;
    private int lineCount;
    private int nextPieceType;
    private int tickSpeed;
    private int hiScore;
    private RecordStore tetrisStore;
    private int hiScoreRecordId;
    private boolean[] completedRows;
    private Random rand;
    private Command exitCommand;
    private Command pauseCommand;
    private Command resumeCommand;
    private int gameState = 0;
    private DropThread dropThread;

    protected void startApp() throws MIDletStateChangeException {
        if (this.gameState == 0) {
            this.init();
        } else if (2 == this.gameState) {
            this.resumeGame();
        } else {
            this.gameCanvas.reset();
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.gameCanvas);
    }

    protected void pauseApp() {
        if (2 == this.gameState) {
            this.pauseGame();
        }
    }

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        if (this.tetrisStore != null) {
            this.writeAndCloseHiScore(this.hiScore);
        }
    }

    private void init() {
        this.board = new TetrisBoard();
        this.gameCanvas = new TetrisCanvas(this);
        this.activePiece = new TetrisPiece();
        this.completedRows = new boolean[20];
        this.hiScore = this.openAndReadHiScore();
        this.nextPieceType = 0;
        this.rand = new Random();
        this.setupCommands();
        this.gameCanvas.addCommand(this.exitCommand);
        this.setGameState(1);
    }

    private void startNewGame(int level) {
        this.gameCanvas.addCommand(this.pauseCommand);
        this.score = 0;
        this.lineCount = 0;
        this.level = level;
        this.nextPieceType = this.getRandomPieceType();
        this.tickSpeed = this.getInitialTickSpeed(this.level);
        this.board.clearBoard();
        this.tryAddNewPiece();
        this.setGameState(2);
        this.runDropThread();
    }

    private void endGame() {
        this.gameCanvas.removeCommand(this.pauseCommand);
        this.hiScore = Math.max(this.hiScore, this.score);
        this.nextPieceType = 0;
        this.setGameState(1);
        this.dropThread.stopThread();
        this.dropThread = null;
    }

    private void pauseGame() {
        this.gameCanvas.removeCommand(this.pauseCommand);
        this.gameCanvas.addCommand(this.resumeCommand);
        this.setGameState(3);
        this.dropThread.stopThread();
    }

    private void resumeGame() {
        this.gameCanvas.removeCommand(this.resumeCommand);
        this.gameCanvas.addCommand(this.pauseCommand);
        this.setGameState(2);
        this.runDropThread();
    }

    private void runDropThread() {
        this.dropThread = new DropThread(this);
        this.dropThread.start();
    }

    private int getInitialTickSpeed(int level) {
        int initialTickSpeed = 1000;
        int i = 0;
        while (i < level) {
            initialTickSpeed = initialTickSpeed * 6 / 7;
            ++i;
        }
        return initialTickSpeed;
    }

    public void keyPressed(int keyCode) {
        if (2 == this.gameState) {
            if (6 == (keyCode = this.gameCanvas.getGameAction(keyCode))) {
                this.tryMoveDown();
            } else if (1 == keyCode) {
                this.tryRotateLeft();
            } else if (2 == keyCode) {
                this.tryMoveLeft();
            } else if (5 == keyCode) {
                this.tryMoveRight();
            } else if (8 == keyCode) {
                this.quickDrop();
            }
        } else if (1 == this.gameState && 48 <= keyCode && 57 >= keyCode) {
            int level = keyCode - 48;
            this.startNewGame(level);
        }
    }

    private synchronized void quickDrop() {
        int dropScore = 0;
        while (this.tryMoveDown()) {
            ++dropScore;
        }
        this.score += dropScore;
        if (this.dropThread != null) {
            this.dropThread.skipNextTick();
        }
    }

    private TetrisPiece newPiece() {
        int pieceType = this.nextPieceType;
        this.nextPieceType = this.getRandomPieceType();
        TetrisPiece activePiece = this.getActivePiece();
        activePiece.setAsNewPiece(pieceType, 4, 2);
        return activePiece;
    }

    private int getRandomPieceType() {
        return Math.abs(this.rand.nextInt() % 7) + 1;
    }

    private int clearCompletedRows(TetrisPiece piece) {
        TetrisBoard board = this.getBoard();
        int i = 0;
        while (i < 4) {
            int rowY = piece.getBlockY(i);
            if (board.checkRowCompleted(rowY)) {
                this.markRowCompleted(rowY, true);
            }
            ++i;
        }
        int numClearedRows = 0;
        int y = 19;
        while (y >= 0) {
            if (numClearedRows > 0) {
                board.dropRow(y, numClearedRows);
            }
            if (this.isRowCompleted(y)) {
                ++numClearedRows;
                this.markRowCompleted(y, false);
            }
            --y;
        }
        int i2 = 0;
        while (i2 < numClearedRows) {
            board.clearRow(i2);
            ++i2;
        }
        return numClearedRows;
    }

    private void markRowCompleted(int row, boolean isCompleted) {
        this.completedRows[row] = isCompleted;
    }

    private boolean isRowCompleted(int row) {
        return this.completedRows[row];
    }

    private void updateRowState(int completedRows) {
        this.lineCount += completedRows;
        if (1 == completedRows) {
            this.score += this.level * 40 + 40;
        } else if (2 == completedRows) {
            this.score += this.level * 100 + 100;
        } else if (3 == completedRows) {
            this.score += this.level * 300 + 300;
        } else if (4 == completedRows) {
            this.score += this.level * 1200 + 1200;
        }
        int level = this.lineCount / 10;
        if (level > this.level) {
            this.level = level;
            this.tickSpeed = this.tickSpeed * 6 / 7;
        }
    }

    private synchronized boolean tryAddNewPiece() {
        TetrisPiece newPiece = this.newPiece();
        TetrisBoard board = this.getBoard();
        if (board.canAddNewPiece(newPiece)) {
            board.addNewPiece(newPiece);
            return true;
        }
        this.endGame();
        return false;
    }

    private synchronized boolean tryMoveDown() {
        TetrisPiece activePiece = this.getActivePiece();
        TetrisBoard board = this.getBoard();
        if (board.canMoveDown(activePiece)) {
            board.moveDown(activePiece);
            this.gameCanvas.repaint();
            return true;
        }
        board.lockPiece(activePiece);
        int numClearedRows = this.clearCompletedRows(activePiece);
        this.updateRowState(numClearedRows);
        this.tryAddNewPiece();
        this.gameCanvas.repaint();
        return false;
    }

    private synchronized boolean tryMoveLeft() {
        if (this.getBoard().canMoveLeft(this.getActivePiece())) {
            this.board.moveLeft(this.getActivePiece());
            this.gameCanvas.repaint();
            return true;
        }
        return false;
    }

    private synchronized boolean tryMoveRight() {
        if (this.getBoard().canMoveRight(this.getActivePiece())) {
            this.board.moveRight(this.getActivePiece());
            this.gameCanvas.repaint();
            return true;
        }
        return false;
    }

    private synchronized boolean tryRotateLeft() {
        if (this.getBoard().canRotateLeft(this.getActivePiece())) {
            this.board.rotateLeft(this.getActivePiece());
            this.gameCanvas.repaint();
            return true;
        }
        return false;
    }

    private synchronized boolean tryRotateRight() {
        if (this.getBoard().canRotateRight(this.getActivePiece())) {
            this.board.rotateRight(this.getActivePiece());
            this.gameCanvas.repaint();
            return true;
        }
        return false;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exitCommand) {
            try {
                this.destroyApp(true);
                this.notifyDestroyed();
            }
            catch (MIDletStateChangeException msce) {}
        } else if (c == this.pauseCommand) {
            this.pauseGame();
        } else if (c == this.resumeCommand) {
            this.resumeGame();
        }
    }

    private void setupCommands() {
        this.exitCommand = new Command("exit", 7, 1);
        this.pauseCommand = new Command("pause", 8, 1);
        this.resumeCommand = new Command("resume", 8, 1);
        this.gameCanvas.setCommandListener(this);
    }

    public void tick() {
        this.tryMoveDown();
    }

    public TetrisBoard getBoard() {
        return this.board;
    }

    public TetrisPiece getActivePiece() {
        return this.activePiece;
    }

    public int getScore() {
        return this.score;
    }

    public int getHiScore() {
        return this.hiScore;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getLevel() {
        return this.level;
    }

    public int getNextPieceType() {
        return this.nextPieceType;
    }

    public int getTickSpeed() {
        return this.tickSpeed;
    }

    public int getGameState() {
        return this.gameState;
    }

    public void setGameState(int gameState) {
        this.gameState = gameState;
        if (this.gameCanvas != null) {
            this.gameCanvas.reset();
            this.gameCanvas.repaint();
        }
    }

    private int openAndReadHiScore() {
        int hiScore = 0;
        try {
            this.tetrisStore = RecordStore.openRecordStore((String)"TetrisStore", (boolean)true);
            if (this.tetrisStore.getNumRecords() > 0) {
                RecordEnumeration recordEnum = this.tetrisStore.enumerateRecords(null, null, false);
                this.hiScoreRecordId = recordEnum.nextRecordId();
                byte[] hiScoreBytes = this.tetrisStore.getRecord(this.hiScoreRecordId);
                ByteArrayInputStream byteIn = new ByteArrayInputStream(hiScoreBytes);
                DataInputStream dataIn = new DataInputStream(byteIn);
                hiScore = dataIn.readInt();
                dataIn.close();
                byteIn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hiScore;
    }

    private void writeAndCloseHiScore(int score) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(4);
            DataOutputStream dataOut = new DataOutputStream(byteOut);
            dataOut.writeInt(this.hiScore);
            byte[] hiScoreBytes = byteOut.toByteArray();
            if (this.tetrisStore.getNumRecords() == 0) {
                this.tetrisStore.addRecord(hiScoreBytes, 0, hiScoreBytes.length);
            } else {
                this.tetrisStore.setRecord(this.hiScoreRecordId, hiScoreBytes, 0, hiScoreBytes.length);
            }
            this.tetrisStore.closeRecordStore();
            dataOut.close();
            byteOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

