/*
 * Decompiled with CFR 0.152.
 */
package tetris.model;

import tetris.model.TetrisPiece;

public class TetrisBoard {
    private int[][] boardBlocks = new int[10][20];

    public TetrisBoard() {
        this.clearBoard();
    }

    public void clearBoard() {
        int y = 0;
        while (y < 20) {
            this.clearRow(y);
            ++y;
        }
    }

    public void clearRow(int rowY) {
        int x = 0;
        while (x < 10) {
            this.setBlockType(x, rowY, -1);
            ++x;
        }
    }

    public void lockPiece(TetrisPiece piece) {
        int pieceType = piece.getPieceType();
        this.updatePieceBlocks(piece, pieceType);
    }

    public boolean checkRowCompleted(int rowY) {
        int x = 0;
        while (x < 10) {
            if (-1 == this.getBlockType(x, rowY)) {
                return false;
            }
            ++x;
        }
        return true;
    }

    public void dropRow(int rowY, int numRows) {
        int x = 0;
        while (x < 10) {
            int blockType = this.getBlockType(x, rowY);
            this.setBlockType(x, rowY + numRows, blockType);
            ++x;
        }
    }

    public int getBlockType(int x, int y) {
        return this.boardBlocks[x][y];
    }

    private void setBlockType(int x, int y, int pieceType) {
        this.boardBlocks[x][y] = pieceType;
    }

    private boolean checkBlockMove(int x, int y) {
        if (this.isOnBoard(x, y)) {
            int blockType = this.getBlockType(x, y);
            return -1 == blockType || -2 == blockType;
        }
        return false;
    }

    private boolean isOnBoard(int x, int y) {
        return x >= 0 && x < 10 && y >= 0 && y < 20;
    }

    private void updatePieceBlocks(TetrisPiece piece, int blockType) {
        int i = 0;
        while (i < 4) {
            int blockX = piece.getBlockX(i);
            int blockY = piece.getBlockY(i);
            this.setBlockType(blockX, blockY, blockType);
            ++i;
        }
    }

    public boolean canAddNewPiece(TetrisPiece piece) {
        int i = 0;
        while (i < 4) {
            int blockY;
            int blockX = piece.getBlockX(i);
            if (!this.checkBlockMove(blockX, blockY = piece.getBlockY(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addNewPiece(TetrisPiece piece) {
        this.updatePieceBlocks(piece, -2);
    }

    public boolean canMoveDown(TetrisPiece piece) {
        return this.canTranslatePiece(piece, 0, 1);
    }

    public boolean canMoveLeft(TetrisPiece piece) {
        return this.canTranslatePiece(piece, -1, 0);
    }

    public boolean canMoveRight(TetrisPiece piece) {
        return this.canTranslatePiece(piece, 1, 0);
    }

    private boolean canTranslatePiece(TetrisPiece piece, int dx, int dy) {
        int i = 0;
        while (i < 4) {
            int blockY;
            int moveY;
            int blockX = piece.getBlockX(i);
            int moveX = blockX + dx;
            if (!this.checkBlockMove(moveX, moveY = (blockY = piece.getBlockY(i)) + dy)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void moveDown(TetrisPiece piece) {
        this.translatePiece(piece, 0, 1);
    }

    public void moveLeft(TetrisPiece piece) {
        this.translatePiece(piece, -1, 0);
    }

    public void moveRight(TetrisPiece piece) {
        this.translatePiece(piece, 1, 0);
    }

    public void translatePiece(TetrisPiece piece, int dx, int dy) {
        this.updatePieceBlocks(piece, -1);
        piece.translatePiece(dx, dy);
        this.updatePieceBlocks(piece, -2);
    }

    public boolean canRotateLeft(TetrisPiece piece) {
        return this.canRotatePiece(piece, piece.getBlockX(1), piece.getBlockY(1), true);
    }

    public boolean canRotateRight(TetrisPiece piece) {
        return this.canRotatePiece(piece, piece.getBlockX(1), piece.getBlockY(1), false);
    }

    private boolean canRotatePiece(TetrisPiece piece, int pivotX, int pivotY, boolean rotateDirection) {
        int rotationType = piece.getRotationType();
        if (1 == rotationType) {
            return false;
        }
        if (2 == rotationType) {
            rotateDirection = piece.getRotationToggle();
        }
        int i = 0;
        while (i < 4) {
            int blockX = piece.getBlockX(i);
            int blockY = piece.getBlockY(i);
            int dx = blockY - pivotY;
            int dy = blockX - pivotX;
            if (rotateDirection) {
                dx *= -1;
            } else {
                dy *= -1;
            }
            int rotateX = pivotX + dx;
            int rotateY = pivotY + dy;
            if (!this.checkBlockMove(rotateX, rotateY)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void rotateLeft(TetrisPiece piece) {
        this.rotatePiece(piece, piece.getBlockX(1), piece.getBlockY(1), true);
    }

    public void rotateRight(TetrisPiece piece) {
        this.rotatePiece(piece, piece.getBlockX(1), piece.getBlockY(1), false);
    }

    private void rotatePiece(TetrisPiece piece, int pivotX, int pivotY, boolean direction) {
        this.updatePieceBlocks(piece, -1);
        piece.rotate(pivotX, pivotY, direction);
        this.updatePieceBlocks(piece, -2);
    }
}

