/*
 * Decompiled with CFR 0.152.
 */
package tetris.ui;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tetris.TetrisMidlet;
import tetris.model.TetrisBoard;
import tetris.ui.InfoBox;
import tetris.ui.NextPieceBox;
import tetris.ui.TitleBox;

public class TetrisCanvas
extends Canvas {
    private TetrisMidlet game;
    private int boardX;
    private int boardY;
    private int boardWidth;
    private int boardHeight;
    private int screenWidth;
    private int screenHeight;
    private int viewableWidth;
    private int viewableHeight;
    private int blockSize;
    private int infoPanelX;
    private int infoPanelWidth;
    private InfoBox scoreBox;
    private InfoBox lineCountBox;
    private InfoBox levelBox;
    private NextPieceBox nextPieceBox;
    private TitleBox titleBox;
    private Font font;
    private Image doubleBuffer;
    private boolean paintedOnce;
    private int[][] lastBoardState;

    public TetrisCanvas(TetrisMidlet game) {
        this.game = game;
        this.lastBoardState = new int[10][18];
        if (!this.isDoubleBuffered()) {
            this.doubleBuffer = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        }
        this.setupLayout();
    }

    protected void keyPressed(int keyCode) {
        this.game.keyPressed(keyCode);
    }

    public void paint(Graphics g) {
        if (this.doubleBuffer == null) {
            this.paintScreen(g);
        } else {
            Graphics bufferG = this.doubleBuffer.getGraphics();
            this.paintScreen(bufferG);
            g.drawImage(this.doubleBuffer, 0, 0, 20);
        }
    }

    private void paintScreen(Graphics g) {
        TetrisBoard board = this.game.getBoard();
        if (!this.paintedOnce) {
            this.paintOnce(g);
            this.paintedOnce = true;
        } else if (2 == this.game.getGameState()) {
            this.paintInfoBoxes(g);
            this.paintBoard(g);
        }
    }

    private void paintOnce(Graphics g) {
        g.setColor(0x999999);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        this.scoreBox.paint(g);
        this.lineCountBox.paint(g);
        this.levelBox.paint(g);
        this.nextPieceBox.paint(g);
        if (1 == this.game.getGameState()) {
            this.paintBoard(g);
            this.titleBox.setHiScore(this.game.getHiScore());
            this.titleBox.paint(g);
        } else if (2 == this.game.getGameState()) {
            this.paintBoard(g);
        } else if (3 == this.game.getGameState()) {
            this.paintPausedBoard(g);
        }
    }

    private void paintInfoBoxes(Graphics g) {
        if (this.scoreBox.updateValue(this.game.getScore())) {
            this.scoreBox.paint(g);
        }
        if (this.lineCountBox.updateValue(this.game.getLineCount())) {
            this.lineCountBox.paint(g);
        }
        if (this.levelBox.updateValue(this.game.getLevel())) {
            this.levelBox.paint(g);
        }
        if (this.nextPieceBox.setPieceType(this.game.getNextPieceType())) {
            this.nextPieceBox.paint(g);
        }
    }

    private void paintPausedBoard(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(this.boardX, this.boardY, this.boardWidth, this.boardHeight);
        int boardCenterX = this.boardX + this.boardWidth / 2;
        int boardCenterY = this.boardY + this.boardHeight / 2;
        g.setColor(0);
        g.drawString("paused", boardCenterX, boardCenterY, 33);
    }

    private void paintBoard(Graphics g) {
        TetrisBoard board = this.game.getBoard();
        int x = 0;
        while (x < 10) {
            int y = 2;
            while (y < 20) {
                int blockType = board.getBlockType(x, y);
                if (blockType != this.getLastBoardState(x, y) || -2 == blockType) {
                    this.paintBlock(x, y, blockType, g);
                    this.setLastBoardState(x, y, blockType);
                }
                ++y;
            }
            ++x;
        }
    }

    private int getLastBoardState(int x, int y) {
        return this.lastBoardState[x][y - 2];
    }

    private void setLastBoardState(int x, int y, int blockType) {
        this.lastBoardState[x][y - 2] = blockType;
    }

    private void paintBlock(int x, int y, int blockType, Graphics g) {
        int blockX = this.boardX + this.blockSize * x;
        int blockY = this.boardY + this.blockSize * (y - 2);
        if (-1 != blockType) {
            g.setColor(0);
            g.fillRect(blockX + 1, blockY + 1, this.blockSize - 1, this.blockSize - 1);
            this.setColor(blockType, g);
            g.fillRect(blockX, blockY, this.blockSize - 1, this.blockSize - 1);
        } else {
            g.setColor(0xFFFFFF);
            g.fillRect(blockX, blockY, this.blockSize, this.blockSize);
        }
    }

    public void reset() {
        this.paintedOnce = false;
        int x = 0;
        while (x < 10) {
            int y = 2;
            while (y < 20) {
                this.setLastBoardState(x, y, 0);
                ++y;
            }
            ++x;
        }
        this.repaint();
    }

    private void setColor(int blockType, Graphics g) {
        switch (blockType) {
            case -1: {
                g.setColor(0xFFFFFF);
                break;
            }
            case -2: {
                this.setColor(this.game.getActivePiece().getPieceType(), g);
                break;
            }
            case 1: {
                g.setColor(0xFF0000);
                break;
            }
            case 2: {
                g.setColor(0xFFFF00);
                break;
            }
            case 3: {
                g.setColor(0xFF9933);
                break;
            }
            case 4: {
                g.setColor(65280);
                break;
            }
            case 5: {
                g.setColor(39168);
                break;
            }
            case 6: {
                g.setColor(255);
                break;
            }
            case 7: {
                g.setColor(65535);
            }
        }
    }

    private void setupLayout() {
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.font = Font.getFont((int)0, (int)0, (int)8);
        int sampleLabelWidth = this.font.stringWidth("10000000");
        this.infoPanelWidth = sampleLabelWidth + sampleLabelWidth / 4;
        this.infoPanelX = this.screenWidth - this.infoPanelWidth;
        int infoBoxHeight = this.font.getHeight() * 2;
        int remainderWidth = this.screenWidth - this.infoPanelWidth;
        this.boardX = 0;
        this.boardY = 0;
        this.viewableWidth = this.screenWidth;
        this.viewableHeight = this.screenHeight;
        int blockWidth = remainderWidth / 10;
        int blockHeight = this.screenHeight / 18;
        this.blockSize = Math.min(blockWidth, blockHeight);
        this.boardWidth = this.blockSize * 10;
        this.boardHeight = this.blockSize * 18;
        this.viewableWidth = this.boardWidth + this.infoPanelWidth;
        this.viewableHeight = this.boardHeight;
        this.boardX = (this.screenWidth - this.viewableWidth) / 2;
        this.boardY = (this.screenHeight - this.viewableHeight) / 2;
        this.infoPanelX = this.boardX + this.boardWidth;
        int infoBoxTotalHeight = infoBoxHeight * 9 / 2;
        int remainderHeight = this.viewableHeight - infoBoxTotalHeight;
        int infoBoxY = this.boardY + remainderHeight / 2;
        this.scoreBox = new InfoBox(this.infoPanelX, infoBoxY, this.infoPanelWidth, infoBoxHeight, 0, 0xBBBBBB, this.font, "score", this.game.getScore());
        this.levelBox = new InfoBox(this.infoPanelX, infoBoxY += infoBoxHeight, this.infoPanelWidth, infoBoxHeight, 0, 0xBBBBBB, this.font, "level", this.game.getLevel());
        this.lineCountBox = new InfoBox(this.infoPanelX, infoBoxY += infoBoxHeight, this.infoPanelWidth, infoBoxHeight, 0, 0xBBBBBB, this.font, "lines", this.game.getLineCount());
        this.nextPieceBox = new NextPieceBox(this.infoPanelX, infoBoxY += infoBoxHeight, this.infoPanelWidth, infoBoxHeight * 3 / 2, 0, 0xBBBBBB, this.font);
        int titleBoxWidth = this.font.stringWidth("hi score: 1000000000000");
        int titleBoxHeight = this.viewableHeight / 2;
        titleBoxHeight = Math.max(titleBoxHeight, this.font.getHeight() * 4);
        int titleBoxX = this.boardX + (this.boardWidth - titleBoxWidth) / 2;
        titleBoxX = Math.max(titleBoxX, 0);
        int titleBoxY = this.boardY + (this.boardHeight - titleBoxHeight) / 2;
        titleBoxY = Math.max(titleBoxY, 0);
        this.titleBox = new TitleBox(titleBoxX, titleBoxY, titleBoxWidth, titleBoxHeight, 0, 0xBBBBBB, this.font);
    }
}

