/*
 * Decompiled with CFR 0.152.
 */
package tetris.ui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import tetris.ui.DisplayBox;

public class NextPieceBox
extends DisplayBox {
    private int pieceType;
    private Font captionFont;
    private int leftBlockX;
    private int blockSize;

    public NextPieceBox(int x, int y, int width, int height, int fgColor, int bgColor, Font captionFont) {
        super(x, y, width, height, fgColor, bgColor);
        this.captionFont = captionFont;
        this.setupLayout();
    }

    private void setupLayout() {
        int gridSize = 6;
        this.blockSize = Math.min(this.width / 6, this.height / 6);
        this.leftBlockX = this.x + (this.width - this.blockSize * 6) / 2;
    }

    public boolean setPieceType(int pieceType) {
        if (this.pieceType != pieceType) {
            this.pieceType = pieceType;
            return true;
        }
        return false;
    }

    protected void paintBoxContents(Graphics g) {
        g.setColor(this.fgColor);
        int xCenter = this.x + this.width / 2;
        g.setFont(this.captionFont);
        g.drawString("next", xCenter, this.y, 17);
        switch (this.pieceType) {
            case 1: {
                this.paintIPiece(g);
                break;
            }
            case 2: {
                this.paintOPiece(g);
                break;
            }
            case 3: {
                this.paintTPiece(g);
                break;
            }
            case 4: {
                this.paintSPiece(g);
                break;
            }
            case 5: {
                this.paintZPiece(g);
                break;
            }
            case 6: {
                this.paintLPiece(g);
                break;
            }
            case 7: {
                this.paintJPiece(g);
            }
        }
    }

    private void paintBlock(int x, int y, int blockSize, int color, Graphics g) {
        g.setColor(0);
        g.fillRect(x + 1, y + 1, blockSize - 1, blockSize - 1);
        g.setColor(color);
        g.fillRect(x, y, blockSize - 1, blockSize - 1);
    }

    private void paintIPiece(Graphics g) {
        int color = 0xFF0000;
        int x = this.leftBlockX + this.blockSize;
        int y = this.y + this.height - this.blockSize * 2;
        this.paintBlock(x, y, this.blockSize, color, g);
        this.paintBlock(x + this.blockSize, y, this.blockSize, color, g);
        this.paintBlock(x + 2 * this.blockSize, y, this.blockSize, color, g);
        this.paintBlock(x + 3 * this.blockSize, y, this.blockSize, color, g);
    }

    private void paintOPiece(Graphics g) {
        int color = 0xFFFF00;
        int x = this.leftBlockX + this.blockSize * 2;
        int y = this.y + this.height - this.blockSize * 3;
        this.paintBlock(x, y, this.blockSize, color, g);
        this.paintBlock(x + this.blockSize, y, this.blockSize, color, g);
        this.paintBlock(x, y + this.blockSize, this.blockSize, color, g);
        this.paintBlock(x + this.blockSize, y + this.blockSize, this.blockSize, color, g);
    }

    private void paintTPiece(Graphics g) {
        int color = 0xFF9933;
        int x = this.leftBlockX + this.blockSize * 3;
        int y = this.y + this.height - this.blockSize * 3;
        this.paintBlock(x, y, this.blockSize, color, g);
        this.paintBlock(x - this.blockSize, y + this.blockSize, this.blockSize, color, g);
        this.paintBlock(x, y + this.blockSize, this.blockSize, color, g);
        this.paintBlock(x + this.blockSize, y + this.blockSize, this.blockSize, color, g);
    }

    private void paintSPiece(Graphics g) {
        int color = 65280;
        int x = this.leftBlockX + this.blockSize * 2;
        int y = this.y + this.height - this.blockSize * 3;
        this.paintBlock(x, y, this.blockSize, color, g);
        this.paintBlock(x + this.blockSize, y, this.blockSize, color, g);
        this.paintBlock(x - this.blockSize, y + this.blockSize, this.blockSize, color, g);
        this.paintBlock(x, y + this.blockSize, this.blockSize, color, g);
    }

    private void paintZPiece(Graphics g) {
        int color = 39168;
        int x = this.leftBlockX + this.blockSize;
        int y = this.y + this.height - this.blockSize * 3;
        this.paintBlock(x, y, this.blockSize, color, g);
        this.paintBlock(x + this.blockSize, y, this.blockSize, color, g);
        this.paintBlock(x + this.blockSize, y + this.blockSize, this.blockSize, color, g);
        this.paintBlock(x + this.blockSize * 2, y + this.blockSize, this.blockSize, color, g);
    }

    private void paintLPiece(Graphics g) {
        int color = 255;
        int x = this.leftBlockX + this.blockSize * 2;
        int y = this.y + this.height - this.blockSize * 4;
        this.paintBlock(x, y, this.blockSize, color, g);
        this.paintBlock(x, y + this.blockSize, this.blockSize, color, g);
        this.paintBlock(x, y + this.blockSize * 2, this.blockSize, color, g);
        this.paintBlock(x + this.blockSize, y + this.blockSize * 2, this.blockSize, color, g);
    }

    private void paintJPiece(Graphics g) {
        int color = 65535;
        int x = this.leftBlockX + this.blockSize * 3;
        int y = this.y + this.height - this.blockSize * 4;
        this.paintBlock(x, y, this.blockSize, color, g);
        this.paintBlock(x, y + this.blockSize, this.blockSize, color, g);
        this.paintBlock(x, y + this.blockSize * 2, this.blockSize, color, g);
        this.paintBlock(x - this.blockSize, y + this.blockSize * 2, this.blockSize, color, g);
    }
}

