/*
 * Decompiled with CFR 0.152.
 */
package tetris.model;

public class TetrisPiece {
    private int[][] blocks = new int[4][2];
    private int pieceType;
    private int rotationType;
    private boolean rotationToggle;

    public void setAsNewPiece(int pieceType, int x, int y) {
        switch (pieceType) {
            case 1: {
                this.setAsNewIPiece(4, 2);
                break;
            }
            case 2: {
                this.setAsNewOPiece(4, 2);
                break;
            }
            case 3: {
                this.setAsNewTPiece(4, 2);
                break;
            }
            case 4: {
                this.setAsNewSPiece(4, 2);
                break;
            }
            case 5: {
                this.setAsNewZPiece(4, 2);
                break;
            }
            case 6: {
                this.setAsNewLPiece(4, 2);
                break;
            }
            case 7: {
                this.setAsNewJPiece(4, 2);
            }
        }
    }

    private void setAsNewIPiece(int x, int y) {
        this.pieceType = 1;
        this.rotationType = 2;
        this.rotationToggle = true;
        this.setBlockCoords(0, x - 1, y);
        this.setBlockCoords(1, x, y);
        this.setBlockCoords(2, x + 1, y);
        this.setBlockCoords(3, x + 2, y);
    }

    private void setAsNewOPiece(int x, int y) {
        this.pieceType = 2;
        this.rotationType = 1;
        this.setBlockCoords(0, x, y);
        this.setBlockCoords(1, x + 1, y);
        this.setBlockCoords(2, x, y + 1);
        this.setBlockCoords(3, x + 1, y + 1);
    }

    private void setAsNewTPiece(int x, int y) {
        this.pieceType = 3;
        this.rotationType = 3;
        this.setBlockCoords(0, x - 1, y);
        this.setBlockCoords(1, x, y);
        this.setBlockCoords(2, x + 1, y);
        this.setBlockCoords(3, x, y + 1);
    }

    private void setAsNewSPiece(int x, int y) {
        this.pieceType = 4;
        this.rotationType = 2;
        this.rotationToggle = true;
        this.setBlockCoords(0, x + 1, y);
        this.setBlockCoords(1, x, y);
        this.setBlockCoords(2, x, y + 1);
        this.setBlockCoords(3, x - 1, y + 1);
    }

    private void setAsNewZPiece(int x, int y) {
        this.pieceType = 5;
        this.rotationType = 2;
        this.rotationToggle = true;
        this.setBlockCoords(0, x - 1, y);
        this.setBlockCoords(1, x, y);
        this.setBlockCoords(2, x, y + 1);
        this.setBlockCoords(3, x + 1, y + 1);
    }

    private void setAsNewLPiece(int x, int y) {
        this.pieceType = 6;
        this.rotationType = 3;
        this.setBlockCoords(0, x - 1, y);
        this.setBlockCoords(1, x, y);
        this.setBlockCoords(2, x + 1, y);
        this.setBlockCoords(3, x - 1, y + 1);
    }

    private void setAsNewJPiece(int x, int y) {
        this.pieceType = 7;
        this.rotationType = 3;
        this.setBlockCoords(0, x - 1, y);
        this.setBlockCoords(1, x, y);
        this.setBlockCoords(2, x + 1, y);
        this.setBlockCoords(3, x + 1, y + 1);
    }

    public int getBlockX(int blockIndex) {
        return this.blocks[blockIndex][0];
    }

    public int getBlockY(int blockIndex) {
        return this.blocks[blockIndex][1];
    }

    public void setBlockCoords(int blockIndex, int x, int y) {
        this.blocks[blockIndex][0] = x;
        this.blocks[blockIndex][1] = y;
    }

    public void translatePiece(int dx, int dy) {
        int i = 0;
        while (i < 4) {
            int moveX = this.getBlockX(i) + dx;
            int moveY = this.getBlockY(i) + dy;
            this.setBlockCoords(i, moveX, moveY);
            ++i;
        }
    }

    public void rotate(int pivotX, int pivotY, boolean rotateDirection) {
        if (2 == this.rotationType) {
            rotateDirection = this.rotationToggle;
            this.rotationToggle = !this.rotationToggle;
        }
        int i = 0;
        while (i < 4) {
            int blockX = this.getBlockX(i);
            int blockY = this.getBlockY(i);
            int dx = blockY - pivotY;
            int dy = blockX - pivotX;
            if (rotateDirection) {
                dx *= -1;
            } else {
                dy *= -1;
            }
            int rotateX = pivotX + dx;
            int rotateY = pivotY + dy;
            this.setBlockCoords(i, rotateX, rotateY);
            ++i;
        }
    }

    public int getPieceType() {
        return this.pieceType;
    }

    public int getRotationType() {
        return this.rotationType;
    }

    public boolean getRotationToggle() {
        return this.rotationToggle;
    }
}

