/*
 * Decompiled with CFR 0.152.
 */
package tetris.ui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import tetris.ui.DisplayBox;

public class InfoBox
extends DisplayBox {
    private String caption;
    private int value;
    private Font font;

    public InfoBox(int x, int y, int width, int height, int fgColor, int bgColor, Font font, String caption, int initialValue) {
        super(x, y, width, height, fgColor, bgColor);
        this.caption = caption;
        this.font = font;
        this.value = initialValue;
    }

    public boolean updateValue(int value) {
        if (this.value != value) {
            this.value = value;
            return true;
        }
        return false;
    }

    protected void paintBoxContents(Graphics g) {
        g.setColor(this.fgColor);
        int xCenter = this.x + this.width / 2;
        g.setFont(this.font);
        g.drawString(this.caption, xCenter, this.y, 17);
        g.setFont(this.font);
        g.drawString(Integer.toString(this.value), xCenter, this.y + this.height, 33);
    }
}

