/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Monster
extends Cords {
    public byte Frame;
    public int Type;
    public byte Dir;
    public byte Speed;
    public byte DeathCounter;
    public int DropType;
    public boolean Dead;
    public boolean Friendly;
    public boolean Still;
    public boolean CanBeKilled;
    boolean ShotWait;
    Image Gfx;
    int Hitrecovery;
    int ShotCount;
    int State;
    int JumpHeight;
    int SizeX;
    int SizeY;
    int FeetPosX;
    int FeetPosY;
    int JumpSpdX;
    int JumpSpdY;
    int HitMoveX;
    int HitMoveY;
    int Life;
    int Str;
    boolean Xmove;
    boolean Ymove;
    Vector Bodies;
    Vector PrevCords;

    Monster(Image i, int x, int y, byte dir, int type) {
        this.PosX = x;
        this.PosY = y + 32;
        this.Dir = dir;
        this.Type = type;
        this.Gfx = i;
        this.MiddleX = 8;
        this.MiddleY = 8;
        this.SizeX = 16;
        this.SizeY = 16;
        this.Speed = 1;
        this.Life = 1;
        this.Str = 2;
        this.Hitrecovery = 0;
        this.CanBeKilled = true;
        this.Friendly = false;
        this.Still = false;
        if (this.Type == 0) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
            this.Speed = (byte)2;
        }
        if (this.Type == 1) {
            this.CanBeKilled = false;
            this.Friendly = false;
            this.Still = true;
        }
        if (this.Type == 3) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
            this.Life = 2;
        }
        if (this.Type == 4) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
        }
        if (this.Type == 5) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
            this.Life = 2;
        }
        if (this.Type == 6) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
            this.Life = 3;
        }
        if (this.Type == 7) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
            this.Speed = (byte)3;
        }
        if (this.Type == 8) {
            Cords2 Temp;
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
            this.Speed = (byte)2;
            this.Str = 4;
            this.Life = 4;
            this.PrevCords = new Vector();
            int j = 0;
            while (j < 22) {
                Temp = new Cords2();
                Temp.PosX = this.PosX;
                Temp.PosY = this.PosY;
                Temp.Life = 3;
                this.PrevCords.addElement(Temp);
                ++j;
            }
            this.Bodies = new Vector();
            Temp = new Cords2();
            Cords2 Temp1 = new Cords2();
            Cords2 Temp2 = new Cords2();
            Cords2 Temp3 = new Cords2();
            Cords2 Temp4 = new Cords2();
            Temp.PosX = this.PosX;
            Temp.PosY = this.PosY;
            Temp.Life = 3;
            this.Bodies.addElement(Temp);
            Temp1.PosX = Temp.PosX - 12;
            Temp1.PosX = Temp.PosY;
            Temp1.Life = Temp.Life;
            this.Bodies.addElement(Temp1);
            Temp2.PosX = Temp1.PosX - 12;
            Temp2.PosX = Temp1.PosY;
            Temp2.Life = Temp1.Life;
            this.Bodies.addElement(Temp2);
            Temp3.PosX = Temp2.PosX - 12;
            Temp3.PosX = Temp2.PosY;
            Temp3.Life = Temp2.Life;
            this.Bodies.addElement(Temp3);
            Temp4.PosX = Temp3.PosX - 12;
            Temp4.PosX = Temp3.PosY;
            Temp4.Life = Temp3.Life;
            this.Bodies.addElement(Temp4);
        }
        if (this.Type == 9) {
            this.CanBeKilled = false;
            this.Friendly = false;
            this.Still = true;
            this.FeetPosX = this.PosX;
            this.FeetPosY = this.PosY;
            this.Str = 4;
        }
        if (this.Type == 10) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
            this.FeetPosX = this.PosX;
            this.FeetPosY = this.PosY;
            this.Str = 2;
            this.Life = 4;
        }
        if (this.Type == 11) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = true;
            this.FeetPosX = this.PosX;
            this.FeetPosY = this.PosY;
            this.Str = 1;
            this.Life = 1;
        }
        if (this.Type == 12) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
            this.FeetPosX = this.PosX;
            this.FeetPosY = this.PosY;
            this.Str = 1;
            this.Life = 2;
        }
        if (this.Type == 16) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
            this.Life = 10;
            this.SizeX = 32;
            this.SizeY = 32;
            this.Str = 4;
            this.MiddleX = 16;
            this.MiddleY = 16;
        }
        if (this.Type == 17) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
            this.Life = 10;
            this.SizeX = 16;
            this.SizeY = 16;
            this.Str = 4;
            this.MiddleX = 8;
            this.MiddleY = 8;
        }
        if (this.Type == 18) {
            this.CanBeKilled = true;
            this.Friendly = false;
            this.Still = false;
            this.Life = 10;
            this.Speed = (byte)2;
            this.SizeX = 32;
            this.SizeY = 32;
            this.Str = 4;
            this.MiddleX = 8;
            this.MiddleY = 8;
        }
        if (this.Type == 128) {
            this.CanBeKilled = false;
            this.Friendly = true;
            this.Still = true;
            this.MiddleY += 4;
        }
        if (this.Type == 129) {
            this.CanBeKilled = false;
            this.Friendly = true;
            this.Still = true;
            this.MiddleY += 4;
        }
        if (this.Type == 130) {
            this.CanBeKilled = false;
            this.Friendly = true;
            this.Still = true;
            this.MiddleY += 4;
        }
    }

    void Draw(Graphics g, int TileXOffset, int TileYOffset, int width, int height) {
        if (width + TileXOffset < this.PosX && this.Type != 8) {
            return;
        }
        if (this.PosX + this.MiddleX + this.MiddleX < TileXOffset && this.Type != 8) {
            return;
        }
        if (height + TileYOffset < this.PosY && this.Type != 8) {
            return;
        }
        if (this.PosY + this.MiddleY + this.MiddleY - 32 < TileYOffset && this.Type != 8) {
            return;
        }
        if (this.Hitrecovery % 3 == 1) {
            this.Animate();
            return;
        }
        g.translate(-g.getTranslateX(), -g.getTranslateY());
        g.translate(this.PosX - TileXOffset, this.PosY - TileYOffset);
        g.setClip(0, 0, 16, 16);
        g.clipRect(0, 0, 16, 16);
        if (!this.Dead) {
            if (this.Type == 0) {
                g.drawImage(this.Gfx, -16 * (this.Frame >> 3), -16 * this.Dir, 0);
            }
            if (this.Type == 1) {
                g.drawImage(this.Gfx, -16 * (this.Frame >> 2), 0, 0);
            }
            if (this.Type == 2) {
                g.drawImage(this.Gfx, -16 * (this.Frame >> 3), 0, 0);
            }
            if (this.Type == 3) {
                g.drawImage(this.Gfx, -16 * (this.Frame >> 3), 0, 0);
            }
            if (this.Type == 4) {
                g.translate(0, 4);
                g.setClip(0, 0, 16, 8);
                g.clipRect(0, 0, 16, 8);
                g.drawImage(this.Gfx, 0, -8 * (this.Frame >> 3), 0);
            }
            if (this.Type == 5) {
                g.drawImage(this.Gfx, -16 * (this.Frame >> 3), -16 * this.Dir, 0);
            }
            if (this.Type == 6) {
                g.drawImage(this.Gfx, -16 * (this.Frame >> 3), -16 * this.Dir, 0);
            }
            if (this.Type == 7) {
                g.drawImage(this.Gfx, -16 * (this.Frame >> 3), -16 * this.Dir, 0);
            }
            if (this.Type == 8) {
                int i = 0;
                while (i < this.Bodies.size()) {
                    Cords2 TempC = (Cords2)this.Bodies.elementAt(i);
                    g.translate(-g.getTranslateX(), -g.getTranslateY());
                    g.translate(TempC.PosX - TileXOffset, TempC.PosY - TileYOffset);
                    if (i == this.Bodies.size() - 1) {
                        g.setClip(0, 0, 16, 16);
                        g.clipRect(0, 0, 16, 16);
                        if (this.Dir == 0) {
                            g.drawImage(this.Gfx, 0, 0, 0);
                        }
                        if (this.Dir == 1) {
                            g.drawImage(this.Gfx, -16, 0, 0);
                        }
                        if (this.Dir == 2) {
                            g.drawImage(this.Gfx, 0, -16, 0);
                        }
                        if (this.Dir == 3) {
                            g.drawImage(this.Gfx, -16, -16, 0);
                        }
                    } else if (i == 0) {
                        g.translate(7, 7);
                        g.setClip(0, 0, 6, 6);
                        g.clipRect(0, 0, 6, 6);
                        g.drawImage(this.Gfx, -12, -32, 0);
                    } else {
                        g.translate(2, 2);
                        g.setClip(0, 0, 12, 12);
                        g.clipRect(0, 0, 12, 12);
                        g.drawImage(this.Gfx, 0, -32, 0);
                    }
                    ++i;
                }
            }
            if (this.Type == 9) {
                g.setClip(0, 0, 16, 16);
                g.clipRect(0, 0, 16, 16);
                g.drawImage(this.Gfx, 0, 0, 0);
            }
            if (this.Type == 10) {
                g.drawImage(this.Gfx, -16 * (this.Frame >> 3), -16 * this.Dir, 0);
            }
            if (this.Type == 11) {
                g.setClip(0, 0, 16, 16);
                g.clipRect(0, 0, 16, 16);
                if (this.State == 0) {
                    // empty if block
                }
                if (this.State == 1) {
                    g.drawImage(this.Gfx, 0, -32, 0);
                }
                if (this.State == 2) {
                    g.drawImage(this.Gfx, -16, -32, 0);
                    g.translate(0, -this.JumpHeight);
                    g.setClip(0, 0, 16, 16);
                    g.clipRect(0, 0, 16, 16);
                    g.drawImage(this.Gfx, 0, -(this.Dir >> 1) * 16, 0);
                    g.translate(0, this.JumpHeight);
                }
                if (this.State == 3) {
                    g.drawImage(this.Gfx, -(this.Frame >> 3) * 16, -(this.Dir >> 1) * 16, 0);
                }
            }
            if (this.Type == 12) {
                g.drawImage(this.Gfx, -16 * (this.Frame >> 3), -16 * this.Dir, 0);
            }
            if (this.Type == 16) {
                g.setClip(0, 0, 32, 32);
                g.clipRect(0, 0, 32, 32);
                g.drawImage(this.Gfx, -32 * (this.Frame >> 3), 0, 0);
            }
            if (this.Type == 17) {
                if (this.Dir % 2 == 1) {
                    g.setClip(0, 0, 32, 16);
                    g.clipRect(0, 0, 32, 16);
                    g.drawImage(this.Gfx, -32 * (this.Frame >> 3), -32 - this.Dir / 2 * 16, 0);
                } else {
                    g.setClip(0, 0, 16, 32);
                    g.clipRect(0, 0, 16, 32);
                    g.drawImage(this.Gfx, -16 * (this.Frame >> 3) - this.Dir / 2 * 32, 0, 0);
                }
            }
            if (this.Type == 18) {
                g.setClip(0, 0, 16, 16);
                g.clipRect(0, 0, 16, 16);
                g.drawImage(this.Gfx, 0, 0, 0);
                if (this.Life > 1) {
                    g.translate(12, 0);
                    g.setClip(0, 0, 16, 16);
                    g.clipRect(0, 0, 16, 16);
                    g.drawImage(this.Gfx, -16 + 16 * (this.Frame >> 3), -32, 0);
                    g.translate(-12, 0);
                }
                if (this.Life > 3) {
                    g.translate(-12, 0);
                    g.setClip(0, 0, 16, 16);
                    g.clipRect(0, 0, 16, 16);
                    g.drawImage(this.Gfx, -16 * (this.Frame >> 3), -16, 0);
                    g.translate(12, 0);
                }
                if (this.Life > 5) {
                    g.translate(0, -12);
                    g.setClip(0, 0, 16, 16);
                    g.clipRect(0, 0, 16, 16);
                    g.drawImage(this.Gfx, -32, -32 + 16 * (this.Frame >> 3), 0);
                    g.translate(0, 12);
                }
                if (this.Life > 7) {
                    g.translate(0, 12);
                    g.setClip(0, 0, 16, 16);
                    g.clipRect(0, 0, 16, 16);
                    g.drawImage(this.Gfx, -16 - 16 * (this.Frame >> 3), 0, 0);
                }
            }
            if (this.Type == 128) {
                g.translate(0, -6);
                g.setClip(0, 0, 16, 24);
                g.clipRect(0, 0, 16, 24);
                g.drawImage(this.Gfx, 0, 0, 0);
            }
            if (this.Type == 129) {
                g.translate(0, -6);
                g.setClip(0, 0, 16, 24);
                g.clipRect(0, 0, 16, 24);
                g.drawImage(this.Gfx, -16, 0, 0);
            }
            if (this.Type == 130) {
                g.translate(0, -6);
                g.setClip(0, 0, 16, 24);
                g.clipRect(0, 0, 16, 24);
                g.drawImage(this.Gfx, -32, 0, 0);
            }
        } else {
            if (this.Type == 16) {
                g.translate(16, 16);
                g.setClip(0, 0, 16, 16);
                g.clipRect(0, 0, 16, 16);
            }
            g.drawImage(this.Gfx, -16 * (this.DeathCounter >> 1), 0, 0);
        }
        this.Animate();
    }

    void Animate() {
        this.Frame = (byte)(this.Frame + 1);
        if (this.Frame > 15) {
            this.Frame = 0;
        }
        if (this.Hitrecovery > 0) {
            --this.Hitrecovery;
        }
        if (this.ShotCount > 0) {
            --this.ShotCount;
        }
    }

    void HandleMonsterAI(player p, Map CurrentMap) {
        if (this.Hitrecovery > 0 && CurrentMap.GetMCol(this.PosX + this.HitMoveX, this.PosY + this.HitMoveY, this.Dir, this.Type, 0) && this.Type != 16) {
            this.PosX += this.HitMoveX;
            this.PosY += this.HitMoveY;
        }
        switch (this.Type) {
            case 7: {
                if (p.PosX + 24 > this.PosX && p.PosX < this.PosX + 16) {
                    this.Speed = (byte)2;
                    if (p.PosY > this.PosY && this.Dir == 2) {
                        this.Speed = (byte)3;
                    }
                    if (p.PosY < this.PosY && this.Dir == 0) {
                        this.Speed = (byte)3;
                    }
                }
                if (p.PosY + 24 <= this.PosY || p.PosY >= this.PosY + 16) break;
                this.Speed = (byte)2;
                if (p.PosX > this.PosX && this.Dir == 1) {
                    this.Speed = (byte)3;
                }
                if (p.PosX >= this.PosX || this.Dir != 3) break;
                this.Speed = (byte)3;
                break;
            }
            case 8: {
                Cords2 TempC = new Cords2();
                TempC.PosX = this.PosX;
                TempC.PosY = this.PosY;
                this.PrevCords.addElement(TempC);
                this.PrevCords.removeElementAt(0);
                int i = 0;
                while (i < this.Bodies.size()) {
                    Cords2 TempC1 = (Cords2)this.Bodies.elementAt(i);
                    Cords2 TempC2 = (Cords2)this.PrevCords.elementAt(i * 5);
                    TempC1.PosX = TempC2.PosX;
                    TempC1.PosY = TempC2.PosY;
                    this.Bodies.setElementAt(TempC1, i);
                    ++i;
                }
                break;
            }
            case 9: {
                if (p.PosX + 18 > this.PosX && p.PosX + 6 < this.PosX + 16 && !this.Xmove) {
                    if (p.PosY > this.PosY && CurrentMap.GetMCol(this.PosX, this.PosY + 5, 2, 9, 0)) {
                        this.PosY += 3;
                        this.Ymove = true;
                    }
                    if (p.PosY >= this.PosY || !CurrentMap.GetMCol(this.PosX, this.PosY - 5, 0, 9, 0)) break;
                    this.PosY -= 3;
                    this.Ymove = true;
                    break;
                }
                if (p.PosY + 18 > this.PosY && p.PosY + 6 < this.PosY + 16 && !this.Ymove) {
                    if (p.PosX > this.PosX && CurrentMap.GetMCol(this.PosX + 5, this.PosY, 1, 9, 0)) {
                        this.PosX += 3;
                        this.Xmove = true;
                    }
                    if (p.PosX >= this.PosX || !CurrentMap.GetMCol(this.PosX - 5, this.PosY, 3, 9, 0)) break;
                    this.PosX -= 3;
                    this.Xmove = true;
                    break;
                }
                if (this.PosY > this.FeetPosY) {
                    if (CurrentMap.GetMCol(this.PosX, this.PosY - 3, 0, 9, 0)) {
                        --this.PosY;
                    } else if (this.PosY - 4 <= this.FeetPosY) {
                        this.PosY = this.FeetPosY;
                    }
                }
                if (this.PosY < this.FeetPosY) {
                    if (CurrentMap.GetMCol(this.PosX, this.PosY + 3, 2, 9, 0)) {
                        ++this.PosY;
                    } else if (this.PosY + 4 >= this.FeetPosY) {
                        this.PosY = this.FeetPosY;
                    }
                }
                if (this.PosX > this.FeetPosX) {
                    if (CurrentMap.GetMCol(this.PosX - 3, this.PosY, 3, 9, 0)) {
                        --this.PosX;
                    } else if (this.PosX - 4 <= this.FeetPosX) {
                        this.PosX = this.FeetPosX;
                    }
                }
                if (this.PosX < this.FeetPosX) {
                    if (CurrentMap.GetMCol(this.PosX + 3, this.PosY, 1, 9, 0)) {
                        ++this.PosX;
                    } else if (this.PosX + 4 >= this.FeetPosX) {
                        this.PosX = this.FeetPosX;
                    }
                }
                if (this.PosY == this.FeetPosY) {
                    this.Ymove = false;
                }
                if (this.PosX != this.FeetPosX) break;
                this.Xmove = false;
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                if (this.State == 0) {
                    if (p.PosX <= this.PosX - 48 || p.PosX >= this.PosX + 48 || p.PosY <= this.PosY - 48 || p.PosY >= this.PosY + 48) break;
                    this.State = 1;
                    break;
                }
                if (this.State == 1) {
                    if (p.PosX > this.PosX - 24 && p.PosX < this.PosX + 24) {
                        if (p.PosY > this.PosY - 24 && p.PosY < this.PosY + 24) {
                            this.State = 3;
                            this.Still = false;
                            if (p.PosX > this.PosX) {
                                this.Dir = 1;
                            }
                            if (p.PosX < this.PosX) {
                                this.Dir = (byte)3;
                            }
                            if (p.PosY > this.PosY) {
                                this.Dir = (byte)2;
                            }
                            if (p.PosY >= this.PosY) break;
                            this.Dir = 0;
                            break;
                        }
                        if (p.PosY > this.PosY - 48 && p.PosY < this.PosY + 48) break;
                        this.State = 0;
                        break;
                    }
                    if (p.PosX > this.PosX - 48 && p.PosX < this.PosX + 48) break;
                    this.State = 0;
                    break;
                }
                if (this.State != 3) break;
                int TempX = 0;
                int TempY = 0;
                if (p.PosX > this.PosX) {
                    TempX = -1;
                    TempY = 0;
                    this.Dir = 1;
                }
                if (p.PosX < this.PosX) {
                    TempX = 1;
                    TempY = 0;
                    this.Dir = (byte)3;
                }
                if (p.PosY > this.PosY) {
                    TempX = 0;
                    TempY = -1;
                    this.Dir = (byte)2;
                }
                if (p.PosY >= this.PosY) break;
                TempX = 0;
                TempY = 1;
                this.Dir = 0;
                break;
            }
        }
    }
}

