/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    Image BasePic;
    private ZeldaCanvas Parent;
    final boolean Sound;
    Image OctoGfx;
    Image OctoGfx2;
    Image Death;
    Image NPC;
    Image Fire;
    Image Jumpy;
    Image Diggy;
    Image Bat;
    Image Boss;
    Image Skele;
    Image Teddy;
    Image Mummy;
    Image Worm;
    Image Worm2;
    Image Spike;
    Image Slime;
    Image Knight;
    Image Moblin;
    Image Ghost;
    Image Wall;
    Image Bomb;
    Image Bush;
    Image BombWall;
    Image BombTree;
    Image Const;
    Image Flowers;
    Image Waterfall1;
    Image Waterfall2;
    Image Net;
    Image Candle1;
    Image Candle2;
    Image Sign;
    Image Brygga;
    Image HookTarget;
    Image Water;
    Image RupiesHearts;
    Image SwordHearts;
    Image KeysNStuff;
    Image Pushable;
    Image Trigger;
    Image Door;
    Image Door2;
    Image Item57;
    Image Item134136;
    Image Item137139;
    Image Item140142;
    Image Triforce;
    Image Stairs;
    Image Fence;
    Image Grave;
    Image ProjStone;
    Image ProjBall;
    Image Bomerang;
    Image ProjArrow;
    Image HookshotPic;
    Image WandShot;
    Image GlowEffect;
    byte[] TileMap;
    byte Xsize;
    byte Ysize;
    byte TileSet;
    byte MapMonsterType;
    Random rand;
    byte TriggerValue;
    int CurrentMapNumber;
    int CurrentWorldNumber;
    int ScreenWidth;
    int ScreenHeight;
    Vector Objects;
    Vector Projectiles;
    Vector Warp;
    Vector Items;
    Vector Monsters;
    Vector Events;
    Vector EventsLevel2;
    Vector Strings;
    Vector VisitedMaps;
    Graphics MapG;

    Map(Graphics g, Graphics g2, player p, ZeldaCanvas canvas) {
        this.Sound = true;
        this.Parent = canvas;
        this.MapG = g2;
        this.TileSet = 0;
        this.VisitedMaps = new Vector();
        this.Objects = new Vector();
        this.Projectiles = new Vector();
        this.Warp = new Vector();
        this.Items = new Vector();
        this.Monsters = new Vector();
        this.Events = new Vector();
        this.EventsLevel2 = new Vector();
        this.Strings = new Vector();
        this.rand = new Random();
        this.BasePic = null;
        System.out.println("Map Constructor");
        if (p == null) {
            this.Test("Maps/Intro.xmap.xmob", g, p, 0, 0, 0, 0, false);
            return;
        }
        this.Test("Maps/Map" + p.CurrentMap + "-" + p.CurrentWorld + ".xmap.xmob", g, p, p.CurrentMap, p.CurrentWorld, 0, 0, true);
        this.CurrentMapNumber = p.CurrentMap;
        this.CurrentWorldNumber = p.CurrentWorld;
        this.VisitedMaps.setSize(16);
    }

    void DrawEffects(Graphics g, int TileXOffset, int TileYOffset, int width, int height, player p) {
        int i = 0;
        while (i < this.Events.size()) {
            Event TempE = (Event)this.Events.elementAt(i);
            TempE.PlayerXpos = p.PosX;
            TempE.PlayerYpos = p.PosY;
            if (TempE.GfxType == 8) {
                if (TempE.Effects != null) {
                    TempE.DrawEffect(g, TileXOffset, TileYOffset, width, height, this.Parent.UseAlpha);
                } else if (this.GlowEffect != null) {
                    TempE.Effects = this.GlowEffect;
                } else {
                    try {
                        this.GlowEffect = this.Parent.UseAlpha ? Image.createImage((String)"/Images/Glow.png") : Image.createImage((String)"/Images/Glow2.png");
                    }
                    catch (IOException e) {
                        return;
                    }
                }
            }
            ++i;
        }
        if (p.Light) {
            if (p.Effects != null) {
                p.DrawEffect(g, TileXOffset, TileYOffset, this.Parent.UseAlpha);
            } else if (this.GlowEffect != null) {
                p.Effects = this.GlowEffect;
            } else {
                try {
                    this.GlowEffect = this.Parent.UseAlpha ? Image.createImage((String)"/Images/Glow.png") : Image.createImage((String)"/Images/Glow2.png");
                }
                catch (IOException e) {
                    return;
                }
            }
        }
    }

    int GetTriggerValue() {
        int val = 0;
        int i = 0;
        while (i < this.Events.size()) {
            Event TempE = (Event)this.Events.elementAt(i);
            if (TempE.Trigger != 0 || TempE.Monsters) {
                if (TempE.Trigger == 3 && TempE.Trigged) {
                    val += TempE.TriggerValue;
                } else if (TempE.Trigger == 2 && TempE.Trigged) {
                    val += TempE.TriggerValue;
                } else if (TempE.Monsters) {
                    if (this.Monsters.size() == 0) {
                        val += TempE.TriggerValue;
                    } else {
                        boolean found = false;
                        int j = 0;
                        while (j < this.Monsters.size()) {
                            Monster TempM = (Monster)this.Monsters.elementAt(j);
                            if (TempM.Type != 9) {
                                found = true;
                            }
                            ++j;
                        }
                        if (!found) {
                            val += TempE.TriggerValue;
                        }
                    }
                }
            }
            ++i;
        }
        return val;
    }

    void ScanTriggers(player p) {
        int x = p.PosX;
        int y = p.PosY - 32;
        x += 12;
        y += 16;
        int i = 0;
        while (i < this.Events.size()) {
            Event TempE = (Event)this.Events.elementAt(i);
            if (TempE.Trigger != 0) {
                if (TempE.Trigger == 3) {
                    TempE.Trigged = false;
                    if (!this.GetMCol(TempE.PosX, TempE.PosY, 4, 100, i)) {
                        TempE.Trigged = true;
                    }
                    if (TempE.PosX <= x && TempE.PosX + 16 >= x && TempE.PosY <= y + 32 && TempE.PosY + 16 >= y + 32) {
                        TempE.Trigged = true;
                    }
                } else if (TempE.Trigger == 1) {
                    TempE.Active = this.GetTriggerValue() < TempE.TriggerValue;
                }
            }
            ++i;
        }
    }

    void UseWarp(int Index) {
        WarpZone warpZone = (WarpZone)this.Warp.elementAt(Index);
    }

    boolean GetCol(int X, int Y, int dir, player p, boolean Move) {
        int x = X;
        int y = Y - 32;
        int pos = 0;
        x += 12;
        y += 16;
        if (p.Layer != 0) {
            int i = 0;
            while (i < this.EventsLevel2.size()) {
                Event TempE = (Event)this.EventsLevel2.elementAt(i);
                if (TempE.PosX <= x && TempE.PosX + TempE.SizeX >= x && TempE.PosY <= y + 32 && TempE.PosY + TempE.SizeY >= y + 32) {
                    return true;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.Events.size()) {
                Event TempE = (Event)this.Events.elementAt(i2);
                if (TempE.PosX <= x && TempE.PosX + TempE.SizeX >= x && TempE.PosY <= y + 32 && TempE.PosY + TempE.SizeY >= y + 32 && TempE.GfxType == 17) {
                    p.Layer = 0;
                    return true;
                }
                ++i2;
            }
            return false;
        }
        pos = (y >> 4) * this.Xsize + (x >> 4);
        if (pos <= this.Xsize * this.Ysize && pos > 0) {
            byte Temp = this.TileMap[pos];
            if ((Temp & 0x40) == 64) {
                return false;
            }
            if ((Temp & 0x80) == 128 && !p.Rafting) {
                return false;
            }
        }
        int i = 0;
        while (i < this.Events.size()) {
            Event TempE = (Event)this.Events.elementAt(i);
            if ((TempE.Solid || TempE.Trigger >= 2 || TempE.GfxType == 18 || TempE.GfxType == 17 || TempE.GfxType >= 21 && TempE.GfxType <= 24) && TempE.Active && TempE.PosX + TempE.OffsetX <= x && TempE.PosX + TempE.SizeX + TempE.OffsetX >= x && TempE.PosY + TempE.OffsetY <= y + 32 && TempE.PosY + TempE.SizeY + TempE.OffsetY >= y + 32) {
                if (TempE.GfxType == 17) {
                    p.Layer = 0;
                    return true;
                }
                if (TempE.GfxType >= 21 && TempE.GfxType <= 24) {
                    System.out.println("standing on it..");
                    int nextx = 0;
                    int nexty = 0;
                    if (p.Dir == 0) {
                        nexty = -4;
                        if (p.Rafting) {
                            nexty = 0;
                        }
                    }
                    if (p.Dir == 1) {
                        nextx = 4;
                    }
                    if (p.Dir == 2) {
                        nexty = 4;
                    }
                    if (p.Dir == 3) {
                        nextx = -4;
                        if (p.Rafting) {
                            nextx = 0;
                        }
                    }
                    if ((pos = (y + nexty >> 4) * this.Xsize + (x + nextx >> 4)) <= this.Xsize * this.Ysize && pos > 0) {
                        byte Temp = this.TileMap[pos];
                        if ((Temp & 0x80) == 128) {
                            if (p.GotRaft) {
                                p.Rafting = true;
                            }
                            System.out.println("Rafting");
                            return true;
                        }
                        if (TempE.PosX + TempE.OffsetX - 4 <= x && TempE.PosX + TempE.SizeX + TempE.OffsetX + 4 >= x && TempE.PosY + TempE.OffsetY - 4 <= y + 32 && TempE.PosY + TempE.SizeY + TempE.OffsetY + 4 >= y + 32) {
                            p.Rafting = false;
                            System.out.println("NOT Rafting");
                            return true;
                        }
                    }
                    System.out.println("test");
                    return true;
                }
                if (TempE.GfxType == 18) {
                    p.Layer = 1;
                    return true;
                }
                if (TempE.Push) {
                    if (TempE.GfxType == 61 && !p.Shield) {
                        if (p.HitRecovery <= 0) {
                            --p.Life;
                            if (p.Life < 0) {
                                p.Life = 0;
                            }
                            if (p.Dir == 0) {
                                p.PosY += 5;
                            }
                            if (p.Dir == 1) {
                                p.PosX -= 5;
                            }
                            if (p.Dir == 2) {
                                p.PosY -= 5;
                            }
                            if (p.Dir == 3) {
                                p.PosX += 5;
                            }
                            p.HitRecovery = 20;
                            this.Parent.StatusChanges = true;
                        }
                        return false;
                    }
                    if (dir == 0 && TempE.PosY + TempE.OffsetY < y + 36 && this.GetMCol(TempE.PosX, TempE.PosY - 1, p.Dir, 100, i)) {
                        if (Move) {
                            --TempE.PosY;
                            --p.PosY;
                        } else {
                            return true;
                        }
                    }
                    if (dir == 1 && TempE.PosX + TempE.OffsetX + TempE.SizeX > x - 4 && this.GetMCol(TempE.PosX, TempE.PosY, p.Dir, 100, i)) {
                        if (Move) {
                            ++TempE.PosX;
                            ++p.PosX;
                        } else {
                            return true;
                        }
                    }
                    if (dir == 2 && TempE.PosY + TempE.OffsetY + TempE.SizeY > y + 28 && this.GetMCol(TempE.PosX, TempE.PosY + 1, p.Dir, 100, i)) {
                        if (Move) {
                            ++TempE.PosY;
                            ++p.PosY;
                        } else {
                            return true;
                        }
                    }
                    if (dir == 3 && TempE.PosX + TempE.SizeX + TempE.OffsetX < x + 4 && this.GetMCol(TempE.PosX - 1, TempE.PosY, p.Dir, 100, i)) {
                        if (Move) {
                            --TempE.PosX;
                            --p.PosX;
                        } else {
                            return true;
                        }
                    }
                }
                if (TempE.Trigger == 2) {
                    TempE.Trigged = true;
                    if (TempE.Solid) {
                        return false;
                    }
                } else if (TempE.Trigger == 3) {
                    TempE.Trigged = true;
                    if (TempE.Solid) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++i;
        }
        if (p.Rafting) {
            byte Temp;
            int i3 = 0;
            while (i3 < this.Events.size()) {
                Event TempE = (Event)this.Events.elementAt(i3);
                if (TempE.PosX + TempE.OffsetX <= x + 16 && TempE.PosX + TempE.SizeX + TempE.OffsetX >= x - 16 && TempE.PosY + TempE.OffsetY <= y + 32 + 16 && TempE.PosY + TempE.SizeY + TempE.OffsetY >= y + 32 - 16 && TempE.GfxType >= 21 && TempE.GfxType <= 24) {
                    return true;
                }
                ++i3;
            }
            if (p.Dir == 0) {
                y -= 8;
            }
            if (p.Dir == 1) {
                x += 8;
            }
            if (p.Dir == 2) {
                y += 8;
            }
            if (p.Dir == 3) {
                x -= 8;
            }
            if ((pos = (y >> 4) * this.Xsize + (x >> 4)) <= this.Xsize * this.Ysize && pos > 0 && ((Temp = this.TileMap[pos]) & 0x80) != 128) {
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    boolean GetSwordCol(player p, MeidaPlayer Mp) {
        PickUp = false;
        x = p.PosX;
        y = p.PosY;
        pos = false;
        boundX = 0;
        boundY = 0;
        if (p.Dir == 0) {
            x += 6;
            y -= 9;
            boundX = 9;
            boundY = 18;
        }
        if (p.Dir == 1) {
            x += 17;
            y += 12;
            boundX = 18;
            boundY = 9;
        }
        if (p.Dir == 2) {
            x += 12;
            y += 20;
            boundX = 9;
            boundY = 18;
        }
        if (p.Dir == 3) {
            x -= 12;
            y += 12;
            boundX = 18;
            boundY = 9;
        }
        i = 0;
        while (i < this.Items.size()) {
            TempI = (Item)this.Items.elementAt(i);
            if (TempI.PosX <= x + boundX && TempI.PosX + TempI.MiddleX * 2 >= x && TempI.PosY <= y + boundY && TempI.PosY + TempI.MiddleY * 2 >= y && TempI.Type != 128 && TempI.Type != 129 && TempI.PickUp(p, Mp)) {
                this.Items.removeElementAt(i);
                PickUp = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.Monsters.size()) {
            TempM = (Monster)this.Monsters.elementAt(i);
            if (TempM.CanBeKilled && !TempM.Dead && TempM.PosX <= x + boundX && TempM.PosX + TempM.SizeX >= x && TempM.PosY <= y + boundY && TempM.PosY + TempM.SizeY >= y && TempM.Type != 17 && TempM.Hitrecovery <= 0) {
                Hit = false;
                if (TempM.Type == 10) {
                    if (TempM.Dir == 0 && p.Dir != 2) {
                        TempM.Life -= p.Damage;
                        Hit = true;
                    }
                    if (TempM.Dir == 1 && p.Dir != 3) {
                        TempM.Life -= p.Damage;
                        Hit = true;
                    }
                    if (TempM.Dir == 2 && p.Dir != 0) {
                        TempM.Life -= p.Damage;
                        Hit = true;
                    }
                    if (TempM.Dir == 3 && p.Dir != 1) {
                        TempM.Life -= p.Damage;
                        Hit = true;
                    }
                } else {
                    TempM.Life -= p.Damage;
                    Hit = true;
                }
                if (TempM.Life <= 0) {
                    TempM.DeathCounter = 0;
                    TempM.Dead = true;
                    TempM.Gfx = this.Death;
                    TempM.Frame = 0;
                } else if (Hit) {
                    TempM.Hitrecovery = 5;
                    if (TempM.Type != 20 && TempM.Type != 21) {
                        if (p.Dir == 0) {
                            TempM.HitMoveY = -5;
                            TempM.HitMoveX = 0;
                        }
                        if (p.Dir == 1) {
                            TempM.HitMoveX = 5;
                            TempM.HitMoveY = 0;
                        }
                        if (p.Dir == 2) {
                            TempM.HitMoveX = 0;
                            TempM.HitMoveY = 5;
                        }
                        if (p.Dir == 3) {
                            TempM.HitMoveX = -5;
                            TempM.HitMoveY = 0;
                        }
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.Events.size()) {
            block44: {
                TempE = (Event)this.Events.elementAt(i);
                if (!TempE.Destroy && TempE.Text <= 0 || !TempE.Active) break block44;
                if (TempE.PosX + TempE.OffsetX > x + boundX || TempE.PosX + TempE.SizeX + TempE.OffsetX < x || TempE.PosY + TempE.OffsetY > y + boundY || TempE.PosY + TempE.SizeY + TempE.OffsetY < y) ** GOTO lbl145
                if (TempE.Text > 0) {
                    this.Parent.ConfirmEvent = i;
                    this.Parent.WaitForConfirm = true;
                    p.sword = false;
                    return false;
                }
                if (TempE.Fire && TempE.GfxType == 11) {
                    TempE.Trigged = true;
                    TempE.Trigger = (byte)2;
                    TempE.GfxType = 8;
                    TempE.Gfx = this.GetEventGfx(8);
                    TempE.Solid = true;
                    TempE.Destroy = false;
                } else {
                    if (TempE.Sword) {
                        if (TempE.GfxType == 3 || TempE.GfxType == 4 || TempE.GfxType == 15) {
                            if (!TempE.Dead) {
                                TempE.Dead = true;
                                TempE.DeathCounter = 5;
                            }
                        } else {
                            this.Events.removeElementAt(i);
                        }
                    }
                    if (TempE.Key && p.Keys > 0) {
                        Temp = this.CurrentMapNumber / 32;
                        TempUid = TempE.EventUid % 32;
                        if (this.CurrentWorldNumber == 0) {
                            v0 = Temp;
                            p.EventUid_0[v0] = p.EventUid_0[v0] | 1 << TempUid;
                        }
                        if (this.CurrentWorldNumber == 1) {
                            v1 = Temp;
                            p.EventUid_1[v1] = p.EventUid_1[v1] | 1 << TempUid;
                        }
                        if (this.CurrentWorldNumber == 3) {
                            v2 = Temp;
                            p.EventUid_3[v2] = p.EventUid_3[v2] | 1 << TempUid;
                        }
                        if (this.CurrentWorldNumber == 4) {
                            v3 = Temp;
                            p.EventUid_4[v3] = p.EventUid_4[v3] | 1 << TempUid;
                        }
                        if (this.CurrentWorldNumber == 5) {
                            v4 = Temp;
                            p.EventUid_5[v4] = p.EventUid_5[v4] | 1 << TempUid;
                        }
                        if (this.CurrentWorldNumber == 6) {
                            v5 = Temp;
                            p.EventUid_6[v5] = p.EventUid_6[v5] | 1 << TempUid;
                            System.out.println("Curent worl set " + TempUid);
                        }
                        if (this.CurrentWorldNumber == 7) {
                            v6 = Temp;
                            p.EventUid_7[v6] = p.EventUid_7[v6] | 1 << TempUid;
                        }
                        if (this.CurrentWorldNumber == 8) {
                            v7 = Temp;
                            p.EventUid_8[v7] = p.EventUid_8[v7] | 1 << TempUid;
                        }
                        if (this.CurrentWorldNumber == 9) {
                            v8 = Temp;
                            p.EventUid_9[v8] = p.EventUid_9[v8] | 1 << TempUid;
                        }
                        if (this.CurrentWorldNumber == 10) {
                            v9 = Temp;
                            p.EventUid_10[v9] = p.EventUid_10[v9] | 1 << TempUid;
                        }
                        if (this.CurrentWorldNumber == 11) {
                            v10 = Temp;
                            p.EventUid_11[v10] = p.EventUid_11[v10] | 1 << TempUid;
                        }
                        p.sword = false;
                        --p.Keys;
                        this.Events.removeElementAt(i);
                        PickUp = true;
                    }
lbl145:
                    // 4 sources

                    if ((TempE.GfxType == 3 || TempE.GfxType == 4 || TempE.GfxType == 15) && TempE.Dead) {
                        --TempE.DeathCounter;
                        if (TempE.DeathCounter <= 0) {
                            this.RandomDrop(TempE.PosX, TempE.PosY, p, TempE.DropLevel);
                            this.Events.removeElementAt(i);
                        }
                    }
                }
            }
            ++i;
        }
        return PickUp;
    }

    boolean GetMCol(int X, int Y, int dir, int Type2, int EventId) {
        int x = X;
        int y = Y - 32;
        int pos = 0;
        int OffsX = 0;
        int OffsY = 0;
        if (dir == 0) {
            OffsY = -8;
        }
        if (dir == 1) {
            OffsX = 8;
        }
        if (dir == 2) {
            OffsY = 8;
        }
        if (dir == 3) {
            OffsX = -8;
        }
        if (Type2 == 0) {
            x += 8;
            y += 8;
        }
        if (Type2 == 1) {
            x += 8;
            y += 8;
        }
        if (Type2 == 2) {
            x += 8;
            y += 8;
        }
        if (Type2 == 3) {
            x += 8;
            y += 8;
        }
        if (Type2 == 4) {
            x += 8;
            y += 8;
        }
        if (Type2 == 5) {
            x += 8;
            y += 8;
        }
        if (Type2 == 6) {
            x += 8;
            y += 8;
        }
        if (Type2 == 7) {
            x += 8;
            y += 8;
        }
        if (Type2 == 8) {
            x += 8;
            y += 8;
        }
        if (Type2 == 9) {
            x += 8;
            y += 8;
        }
        if (Type2 == 10) {
            x += 8;
            y += 8;
        }
        if (Type2 == 11) {
            x += 8;
            y += 8;
        }
        if (Type2 == 12) {
            x += 8;
            y += 8;
        }
        if (Type2 == 13) {
            x += 8;
            y += 8;
        }
        if (Type2 == 15) {
            x += 8;
            y += 8;
        }
        if (Type2 == 16) {
            x += 30;
            y += 32;
        }
        if (Type2 == 19) {
            x += 8;
            y += 8;
        }
        if (Type2 == 100) {
            x += 8;
            y += 8;
        }
        if ((pos = (y + OffsY >> 4) * this.Xsize + (x + OffsX >> 4)) <= this.Xsize * this.Ysize && pos > 0) {
            byte Temp = this.TileMap[pos];
            if ((Temp & 0x40) == 64) {
                return false;
            }
            if ((Temp & 0x80) == 128 && Type2 != 18) {
                return false;
            }
        }
        y += 32;
        int i = 0;
        while (i < this.Events.size()) {
            Event TempE = (Event)this.Events.elementAt(i);
            if ((TempE.Solid || TempE.Trigger >= 2) && (EventId != i || Type2 != 100) && TempE.Active && TempE.PosX + TempE.OffsetX <= x + 6 && TempE.PosX + TempE.OffsetX + TempE.SizeX >= x - 6 && TempE.PosY + TempE.OffsetY <= y + 6 && TempE.PosY + TempE.OffsetY + TempE.SizeY >= y - 6) {
                if (TempE.Trigger == 2) {
                    TempE.Trigged = true;
                } else if (TempE.Trigger == 3) {
                    TempE.Trigged = true;
                } else {
                    return false;
                }
            }
            ++i;
        }
        if (Type2 == 100) {
            int i2 = 0;
            while (i2 < this.Monsters.size()) {
                Monster TempM = (Monster)this.Monsters.elementAt(i2);
                if (TempM.PosX <= x + OffsX && TempM.PosX + TempM.SizeX >= x + OffsX && TempM.PosY <= y + OffsY && TempM.PosY + TempM.SizeY >= y + OffsY) {
                    if (dir == 4) {
                        return false;
                    }
                    if (dir == 0) {
                        if (this.GetMCol(TempM.PosX, TempM.PosY - 5, 0, TempM.Type, 0)) {
                            --TempM.PosY;
                            if (TempM.Type == 9) {
                                TempM.Ymove = true;
                            }
                        } else {
                            return false;
                        }
                    }
                    if (dir == 1) {
                        if (this.GetMCol(TempM.PosX + 5, TempM.PosY, 1, TempM.Type, 0)) {
                            ++TempM.PosX;
                            if (TempM.Type == 9) {
                                TempM.Xmove = true;
                            }
                        } else {
                            return false;
                        }
                    }
                    if (dir == 2) {
                        if (this.GetMCol(TempM.PosX, TempM.PosY + 5, 2, TempM.Type, 0)) {
                            ++TempM.PosY;
                            if (TempM.Type == 9) {
                                TempM.Ymove = true;
                            }
                        } else {
                            return false;
                        }
                    }
                    if (dir == 3) {
                        if (this.GetMCol(TempM.PosX - 5, TempM.PosY, 3, TempM.Type, 0)) {
                            --TempM.PosX;
                            if (TempM.Type == 9) {
                                TempM.Xmove = true;
                            }
                        } else {
                            return false;
                        }
                    }
                }
                ++i2;
            }
        }
        return true;
    }

    boolean ItemCol(player p, Graphics g, int width, int height, MeidaPlayer mp) {
        boolean PickUp = false;
        int x = p.PosX;
        int y = p.PosY;
        boolean pos = false;
        x += 12;
        y += 16;
        if (p.HitRecovery > 0) {
            --p.HitRecovery;
        }
        if (p.HitRecovery < 0) {
            p.HitRecovery = 0;
        }
        int i = 0;
        while (i < this.Items.size()) {
            Item TempI = (Item)this.Items.elementAt(i);
            if (TempI.PosX + TempI.MiddleX <= x + 3 && TempI.PosX + TempI.MiddleX >= x - 10 && TempI.PosY + TempI.MiddleY <= y && TempI.PosY + TempI.MiddleY >= y - 16 && TempI.PickUp(p, mp)) {
                this.Items.removeElementAt(i);
                PickUp = true;
            }
            if (TempI.Type == 4 && TempI.PlayerDropped) {
                --TempI.TimeOut;
                if (TempI.TimeOut <= 0) {
                    if (TempI.TimeOut == 0) {
                        TempI.Explode = 10;
                    } else {
                        --TempI.Explode;
                        this.HandleBombs(TempI.PosX, TempI.PosY, p);
                        mp.SoundFxEvent(4);
                        if (TempI.Explode == 0) {
                            this.Items.removeElementAt(i);
                        }
                    }
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.Events.size()) {
            Event TempE = (Event)this.Events.elementAt(i2);
            if (TempE.PosX <= x && TempE.PosX + TempE.SizeX + TempE.OffsetX >= x && TempE.PosY <= y && TempE.PosY + TempE.SizeY + TempE.OffsetY >= y && TempE.Text == 1) {
                this.Parent.WaitForConfirm = true;
                this.Parent.ConfirmEvent = i2;
            } else if ((TempE.GfxType == 3 || TempE.GfxType == 4 || TempE.GfxType == 15) && TempE.Dead) {
                --TempE.DeathCounter;
                if (TempE.DeathCounter < 0) {
                    this.RandomDrop(TempE.PosX, TempE.PosY, p, TempE.DropLevel);
                    this.Events.removeElementAt(i2);
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.Monsters.size()) {
            Monster TempM = (Monster)this.Monsters.elementAt(i3);
            if (!TempM.Friendly && !TempM.Dead && TempM.PosX <= x && TempM.PosX + TempM.SizeX >= x && TempM.PosY <= y && TempM.PosY + TempM.SizeY >= y && p.HitRecovery <= 0) {
                p.Life -= TempM.Str / p.DamageModifier;
                if (p.Life < 0) {
                    p.Life = 0;
                }
                if (TempM.Type != 21) {
                    if (p.Dir == 0 && this.GetCol(p.PosX, p.PosY + 10, p.Dir, p, true)) {
                        p.PosY += 10;
                    }
                    if (p.Dir == 1 && this.GetCol(p.PosX - 10, p.PosY, p.Dir, p, true)) {
                        p.PosX -= 10;
                    }
                    if (p.Dir == 2 && this.GetCol(p.PosX, p.PosY - 10, p.Dir, p, true)) {
                        p.PosY -= 10;
                    }
                    if (p.Dir == 3 && this.GetCol(p.PosX + 10, p.PosY, p.Dir, p, true)) {
                        p.PosX += 10;
                    }
                } else if (this.GetCol(p.PosX + 50, p.PosY, p.Dir, p, true)) {
                    p.PosX += 50;
                } else if (this.GetCol(p.PosX + 40, p.PosY, p.Dir, p, true)) {
                    p.PosX += 40;
                } else if (this.GetCol(p.PosX + 30, p.PosY, p.Dir, p, true)) {
                    p.PosX += 30;
                } else if (this.GetCol(p.PosX + 20, p.PosY, p.Dir, p, true)) {
                    p.PosX += 20;
                } else if (this.GetCol(p.PosX + 10, p.PosY, p.Dir, p, true)) {
                    p.PosX += 10;
                }
                PickUp = true;
                p.HitRecovery = 20;
            }
            ++i3;
        }
        return PickUp;
    }

    int WarpCol(int X, int Y) {
        int x = X;
        int y = Y - 32;
        boolean pos = false;
        x += 12;
        y += 16;
        int i = 0;
        while (i < this.Warp.size()) {
            WarpZone TempW = (WarpZone)this.Warp.elementAt(i);
            if (TempW.PosX * 16 <= x && (TempW.PosX + 1) * 16 >= x && TempW.PosY * 16 <= y && (TempW.PosY + 1) * 16 >= y) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    void RandomDrop(int x, int y, player p, int DropLevel) {
        boolean Multiball = false;
        if (Math.abs(this.rand.nextInt() % 4) == 3) {
            return;
        }
        int Type2 = -1;
        switch (DropLevel) {
            case 1: {
                Type2 = Math.abs(this.rand.nextInt() % 2);
                if (Type2 <= 0) break;
                Type2 = 3;
                break;
            }
            case 2: {
                Type2 = Math.abs(this.rand.nextInt() % 5);
                if (Type2 != 2) break;
                Type2 = 5;
                break;
            }
            case 3: {
                Type2 = Math.abs(this.rand.nextInt() % 6);
                if (Type2 == 0) {
                    Type2 = 1;
                }
                if (Math.abs(this.rand.nextInt() % 6) != 2) break;
                Multiball = true;
                break;
            }
            default: {
                return;
            }
        }
        if (Type2 == 6) {
            return;
        }
        if (Type2 == 4 && !p.GotBombs) {
            Type2 = 1;
        }
        if (Type2 == 5 && !p.GotBow) {
            Type2 = 1;
        }
        Item TempI = new Item(this.GetItemGfx(Type2), Type2, x, y - 32, 0);
        this.Items.addElement(TempI);
        if (Multiball) {
            Item TempI2 = new Item(this.GetItemGfx(Type2), Type2, x - 16, y - 32, 0);
            this.Items.addElement(TempI2);
            Item TempI3 = new Item(this.GetItemGfx(Type2), Type2, x + 16, y - 32, 0);
            this.Items.addElement(TempI3);
            Item TempI4 = new Item(this.GetItemGfx(Type2), Type2, x, y - 16, 0);
            this.Items.addElement(TempI4);
            Item TempI5 = new Item(this.GetItemGfx(Type2), Type2, x, y, 0);
            this.Items.addElement(TempI5);
        }
    }

    void MoveMonsters(player p) {
        int i = 0;
        while (i < this.Monsters.size()) {
            Monster TempM = (Monster)this.Monsters.elementAt(i);
            byte MoveX = 0;
            byte MoveY = 0;
            TempM.HandleMonsterAI(p, this);
            if (TempM.Dead) {
                TempM.DeathCounter = (byte)(TempM.DeathCounter + 1);
                if (TempM.DeathCounter == 5) {
                    if (TempM.Type == 16) {
                        this.RandomDrop(TempM.PosX + (TempM.MiddleX >> 1), TempM.PosY + 16, p, TempM.DropLevel);
                    } else {
                        this.RandomDrop(TempM.PosX + (TempM.MiddleX >> 1), TempM.PosY, p, TempM.DropLevel);
                    }
                }
                if (TempM.DeathCounter == 7) {
                    this.Monsters.removeElementAt(i);
                    return;
                }
                this.Monsters.setElementAt(TempM, i);
            } else if (!TempM.Still) {
                boolean Set2;
                byte dir;
                if (TempM.Dir == 0) {
                    MoveX = 0;
                    MoveY = -TempM.Speed;
                }
                if (TempM.Dir == 1) {
                    MoveX = TempM.Speed;
                    MoveY = 0;
                }
                if (TempM.Dir == 2) {
                    MoveX = 0;
                    MoveY = TempM.Speed;
                }
                if (TempM.Dir == 3) {
                    MoveX = -TempM.Speed;
                    MoveY = 0;
                }
                if (this.GetMCol(TempM.PosX + MoveX, TempM.PosY + MoveY, TempM.Dir, TempM.Type, 0)) {
                    TempM.PosX += MoveX;
                    TempM.PosY += MoveY;
                    if (TempM.PosX > 240) {
                        TempM.Dir = (byte)3;
                    }
                    if (TempM.PosX < 16) {
                        TempM.Dir = 1;
                    }
                    if (TempM.PosY > 176) {
                        TempM.Dir = 0;
                    }
                    if (TempM.PosY < 32) {
                        TempM.Dir = (byte)2;
                    }
                    if (Math.abs(this.rand.nextInt() % 30) == 0) {
                        dir = (byte)Math.abs(this.rand.nextInt() % 3);
                        Set2 = false;
                        if (TempM.Type == 8) {
                            Set2 = true;
                            if (TempM.Dir % 2 == dir % 2) {
                                TempM.Dir = (byte)(TempM.Dir + 1);
                                if (TempM.Dir > 3) {
                                    TempM.Dir = 0;
                                }
                            } else {
                                TempM.Dir = dir;
                            }
                        }
                        if (TempM.Type == 10) {
                            Set2 = true;
                            if (TempM.Dir % 2 == dir % 2) {
                                TempM.Dir = (byte)(TempM.Dir + 1);
                                if (TempM.Dir > 3) {
                                    TempM.Dir = 0;
                                }
                            } else {
                                TempM.Dir = dir;
                            }
                        }
                        if (TempM.Type == 15) {
                            Set2 = true;
                            if (TempM.Dir % 2 == dir % 2) {
                                TempM.Dir = (byte)(TempM.Dir + 1);
                                if (TempM.Dir > 3) {
                                    TempM.Dir = 0;
                                }
                            } else {
                                TempM.Dir = dir;
                            }
                        }
                        if (TempM.Type == 17) {
                            Set2 = true;
                        }
                        if (TempM.Type == 12) {
                            Set2 = true;
                            if (TempM.Dir % 2 == dir % 2) {
                                TempM.Dir = (byte)(TempM.Dir + 1);
                                if (TempM.Dir > 3) {
                                    TempM.Dir = 0;
                                }
                            } else {
                                TempM.Dir = dir;
                            }
                        }
                        if (TempM.Type == 19) {
                            Set2 = true;
                            if (TempM.Dir % 2 == dir % 2) {
                                TempM.Dir = (byte)(TempM.Dir + 1);
                                if (TempM.Dir > 3) {
                                    TempM.Dir = 0;
                                }
                            } else {
                                TempM.Dir = dir;
                            }
                        }
                        if (TempM.Type == 22) {
                            Set2 = true;
                            if (TempM.Dir % 2 == dir % 2) {
                                TempM.Dir = (byte)(TempM.Dir + 1);
                                if (TempM.Dir > 3) {
                                    TempM.Dir = 0;
                                }
                            } else {
                                TempM.Dir = dir;
                            }
                        }
                        if (!Set2) {
                            TempM.Dir = dir;
                        }
                    }
                    if (TempM.Type == 16) {
                        if (TempM.Dir == 1) {
                            TempM.Dir = 0;
                        }
                        if (TempM.Dir == 3) {
                            TempM.Dir = (byte)2;
                        }
                    }
                    if (TempM.Type == 0 && Math.abs(this.rand.nextInt() % 100) == 5 && TempM.ShotCount <= 0) {
                        Projectile TempP = new Projectile(this.GetProjGfx(0), 0, MoveX, MoveY);
                        TempP.PosX = TempM.PosX + 4;
                        TempP.PosY = TempM.PosY + 4;
                        TempP.Hostile = true;
                        this.Projectiles.addElement(TempP);
                        TempM.ShotCount = 100;
                    }
                    if (TempM.Type == 6 && Math.abs(this.rand.nextInt() % 50) == 5 && !TempM.ShotWait) {
                        Projectile TempP = new Projectile(this.GetProjGfx(2), 2, MoveX, MoveY);
                        TempP.PosX = TempM.PosX + 8 * MoveX;
                        TempP.PosY = TempM.PosY + 8 * MoveY;
                        TempP.ReturnTo = i;
                        TempP.Hostile = true;
                        this.Projectiles.addElement(TempP);
                        TempM.ShotWait = true;
                    }
                    if (TempM.Type == 12 && Math.abs(this.rand.nextInt() % 100) == 5 && TempM.ShotCount <= 0) {
                        Projectile TempP = new Projectile(this.GetProjGfx(3), 3, MoveX, MoveY);
                        TempP.PosX = TempM.PosX + 4;
                        TempP.PosY = TempM.PosY + 4;
                        TempP.Hostile = true;
                        this.Projectiles.addElement(TempP);
                        TempM.ShotCount = 100;
                    }
                    if (TempM.Type == 16 && Math.abs(this.rand.nextInt() % 20) <= 3 && TempM.ShotCount <= 0) {
                        Projectile TempP = new Projectile(this.GetProjGfx(1), 1, -1, 0);
                        TempP.PosX = TempM.PosX + 4;
                        TempP.PosY = TempM.PosY + 4;
                        if (Math.abs(this.rand.nextInt() % 10) <= 4) {
                            TempP.Yinc = p.PosY < TempM.PosY ? -1 : 1;
                        }
                        TempP.Hostile = true;
                        this.Projectiles.addElement(TempP);
                        TempM.ShotCount = 10;
                    }
                } else {
                    dir = (byte)Math.abs(this.rand.nextInt() % 3);
                    Set2 = false;
                    if (TempM.Type == 8) {
                        Set2 = true;
                        if (TempM.Dir % 2 == dir % 2) {
                            TempM.Dir = (byte)(TempM.Dir + 1);
                            if (TempM.Dir > 3) {
                                TempM.Dir = (byte)2;
                            }
                        } else {
                            TempM.Dir = dir;
                        }
                    }
                    if (TempM.Type == 10) {
                        Set2 = true;
                        if (TempM.Dir % 2 == dir % 2) {
                            TempM.Dir = (byte)(TempM.Dir + 1);
                            if (TempM.Dir > 3) {
                                TempM.Dir = (byte)2;
                            }
                        } else {
                            TempM.Dir = dir;
                        }
                    }
                    if (TempM.Type == 15) {
                        Set2 = true;
                        if (TempM.Dir % 2 == dir % 2) {
                            TempM.Dir = (byte)(TempM.Dir + 1);
                            if (TempM.Dir > 3) {
                                TempM.Dir = (byte)2;
                            }
                        } else {
                            TempM.Dir = dir;
                        }
                    }
                    if (TempM.Type == 12) {
                        Set2 = true;
                        if (TempM.Dir % 2 == dir % 2) {
                            TempM.Dir = (byte)(TempM.Dir + 1);
                            if (TempM.Dir > 3) {
                                TempM.Dir = (byte)2;
                            }
                        } else {
                            TempM.Dir = dir;
                        }
                    }
                    if (TempM.Type == 13) {
                        TempM.PosX += MoveX;
                        TempM.PosY += MoveY;
                        if (TempM.PosX > 240) {
                            TempM.Dir = (byte)3;
                        }
                        if (TempM.PosX < 16) {
                            TempM.Dir = 1;
                        }
                        if (TempM.PosY > 176) {
                            TempM.Dir = 0;
                        }
                        if (TempM.PosY < 32) {
                            TempM.Dir = (byte)2;
                        }
                        Set2 = true;
                    }
                    if (TempM.Type == 17) {
                        Set2 = true;
                        TempM.Dir = (byte)(TempM.Dir + 1);
                        if (TempM.Dir > 3) {
                            TempM.Dir = 0;
                        }
                    }
                    if (TempM.Type == 19) {
                        Set2 = true;
                        if (TempM.Dir % 2 == dir % 2) {
                            TempM.Dir = (byte)(TempM.Dir + 1);
                            if (TempM.Dir > 3) {
                                TempM.Dir = (byte)2;
                            }
                        } else {
                            TempM.Dir = dir;
                        }
                    }
                    if (TempM.Type == 22) {
                        Set2 = true;
                        if (TempM.Dir % 2 == dir % 2) {
                            TempM.Dir = (byte)(TempM.Dir + 1);
                            if (TempM.Dir > 3) {
                                TempM.Dir = (byte)2;
                            }
                        } else {
                            TempM.Dir = dir;
                        }
                    }
                    if (!Set2) {
                        TempM.Dir = dir;
                    }
                }
                this.Monsters.setElementAt(TempM, i);
            }
            ++i;
        }
    }

    void HandleBombs(int x, int y, player p) {
        int i = 0;
        while (i < this.Events.size()) {
            Event TempE = (Event)this.Events.elementAt(i);
            if (TempE.PosX <= x + 24 && TempE.PosX + TempE.SizeX >= x - 24 && TempE.PosY <= y + 24 && TempE.PosY + TempE.SizeY >= y - 24) {
                if (TempE.Bomb) {
                    int Temp = this.CurrentMapNumber / 32;
                    int TempUid = TempE.EventUid % 32;
                    if (this.CurrentWorldNumber == 0) {
                        int n = Temp;
                        p.EventUid_0[n] = p.EventUid_0[n] | 1 << TempUid;
                    }
                    if (this.CurrentWorldNumber == 1) {
                        int n = Temp;
                        p.EventUid_1[n] = p.EventUid_1[n] | 1 << TempUid;
                    }
                    if (this.CurrentWorldNumber == 3) {
                        int n = Temp;
                        p.EventUid_3[n] = p.EventUid_3[n] | 1 << TempUid;
                        System.out.println("Curent worl set");
                    }
                    if (this.CurrentWorldNumber == 4) {
                        int n = Temp;
                        p.EventUid_4[n] = p.EventUid_4[n] | 1 << TempUid;
                    }
                    if (this.CurrentWorldNumber == 5) {
                        int n = Temp;
                        p.EventUid_5[n] = p.EventUid_5[n] | 1 << TempUid;
                    }
                    if (this.CurrentWorldNumber == 6) {
                        int n = Temp;
                        p.EventUid_6[n] = p.EventUid_6[n] | 1 << TempUid;
                        System.out.println("Curent worl set");
                    }
                    if (this.CurrentWorldNumber == 7) {
                        int n = Temp;
                        p.EventUid_7[n] = p.EventUid_7[n] | 1 << TempUid;
                    }
                    if (this.CurrentWorldNumber == 8) {
                        int n = Temp;
                        p.EventUid_8[n] = p.EventUid_8[n] | 1 << TempUid;
                    }
                    if (this.CurrentWorldNumber == 9) {
                        int n = Temp;
                        p.EventUid_9[n] = p.EventUid_9[n] | 1 << TempUid;
                    }
                    if (this.CurrentWorldNumber == 10) {
                        int n = Temp;
                        p.EventUid_10[n] = p.EventUid_10[n] | 1 << TempUid;
                    }
                    if (this.CurrentWorldNumber == 11) {
                        int n = Temp;
                        p.EventUid_11[n] = p.EventUid_11[n] | 1 << TempUid;
                    }
                    this.Events.removeElementAt(i);
                }
                if (TempE.Sword) {
                    if (TempE.GfxType == 3 || TempE.GfxType == 4 || TempE.GfxType == 15) {
                        if (!TempE.Dead) {
                            TempE.Dead = true;
                            TempE.DeathCounter = 6;
                        }
                    } else {
                        this.Events.removeElementAt(i);
                        this.RandomDrop(TempE.PosX, TempE.PosY, p, TempE.DropLevel);
                    }
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.Monsters.size()) {
            Monster TempM = (Monster)this.Monsters.elementAt(i2);
            if (TempM.CanBeKilled && !TempM.Dead && TempM.PosX <= x + 24 && TempM.PosX + TempM.SizeX >= x - 24 && TempM.PosY <= y + 24 && TempM.PosY + TempM.SizeY >= y - 24 && TempM.Hitrecovery <= 0) {
                TempM.Life -= 2;
                if (TempM.Life <= 0) {
                    TempM.DeathCounter = 0;
                    TempM.Dead = true;
                    TempM.Gfx = this.Death;
                    TempM.Frame = 0;
                } else {
                    TempM.Hitrecovery = 5;
                    if (TempM.Type != 20) {
                        if (TempM.PosX < x) {
                            TempM.HitMoveY = -10;
                            TempM.HitMoveX = 0;
                        }
                        if (TempM.PosY > y) {
                            TempM.HitMoveX = 10;
                            TempM.HitMoveY = 0;
                        }
                        if (TempM.PosX > x) {
                            TempM.HitMoveX = 0;
                            TempM.HitMoveY = 10;
                        }
                        if (TempM.PosY < y) {
                            TempM.HitMoveX = -10;
                            TempM.HitMoveY = 0;
                        }
                    }
                }
            }
            ++i2;
        }
    }

    Image GetItemGfx(int Type2) {
        block57: {
            try {
                if (Type2 <= 3 && Type2 >= 0) {
                    if (this.RupiesHearts == null) {
                        try {
                            this.RupiesHearts = Image.createImage((String)"/Images/item_Rupies.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.RupiesHearts;
                }
                if (Type2 == 4) {
                    if (this.Bomb == null) {
                        try {
                            this.Bomb = Image.createImage((String)"/Images/Bomb.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.Bomb;
                }
                if (Type2 >= 5 && Type2 <= 7) {
                    if (this.Item57 == null) {
                        try {
                            this.Item57 = Image.createImage((String)"/Images/Item5-7.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.Item57;
                }
                if (Type2 >= 128 && Type2 <= 130) {
                    if (this.SwordHearts == null) {
                        try {
                            this.SwordHearts = Image.createImage((String)"/Images/Item128-131.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.SwordHearts;
                }
                if (Type2 >= 131 && Type2 <= 133) {
                    if (this.KeysNStuff == null) {
                        try {
                            this.KeysNStuff = Image.createImage((String)"/Images/Item131-133.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.KeysNStuff;
                }
                if (Type2 >= 134 && Type2 <= 136) {
                    if (this.Item134136 == null) {
                        try {
                            this.Item134136 = Image.createImage((String)"/Images/Item134-136.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.Item134136;
                }
                if (Type2 >= 137 && Type2 <= 139) {
                    if (this.Item137139 == null) {
                        try {
                            this.Item137139 = Image.createImage((String)"/Images/Item137-139.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.Item137139;
                }
                if (Type2 >= 140 && Type2 <= 142) {
                    if (this.Item140142 == null) {
                        try {
                            this.Item140142 = Image.createImage((String)"/Images/Item140-142.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.Item140142;
                }
                if (Type2 == 143) {
                    if (this.Item140142 == null) {
                        try {
                            this.Item140142 = Image.createImage((String)"/Images/Item153-155.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.Item140142;
                }
                if (Type2 == 144) {
                    if (this.Triforce == null) {
                        try {
                            this.Triforce = Image.createImage((String)"/Images/Triforce.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.Triforce;
                }
                if (Type2 == 145) {
                    if (this.Triforce == null) {
                        try {
                            this.Triforce = Image.createImage((String)"/Images/Mastersword.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.Triforce;
                }
                if (Type2 == 146) {
                    if (this.KeysNStuff == null) {
                        try {
                            this.KeysNStuff = Image.createImage((String)"/Images/Item131-133.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.KeysNStuff;
                }
                if (Type2 >= 147 && Type2 <= 149) {
                    if (this.Triforce == null) {
                        try {
                            this.Triforce = Image.createImage((String)"/Images/Rupies2.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.Triforce;
                }
                if (Type2 < 150 || Type2 > 152) break block57;
                if (this.Item140142 == null) {
                    try {
                        this.Item140142 = Image.createImage((String)"/Images/Item150-152.png");
                    }
                    catch (IOException e) {
                        System.out.println("error loadin item img");
                        return null;
                    }
                }
                return this.Item140142;
            }
            catch (OutOfMemoryError e) {
                this.BasePic = null;
                System.out.println("Error... out of memory");
                System.gc();
                return this.GetItemGfx(Type2);
            }
        }
        return null;
    }

    Image GetProjGfx(int Type2) {
        block29: {
            try {
                if (Type2 == 0) {
                    if (this.ProjStone == null) {
                        try {
                            this.ProjStone = Image.createImage((String)"/Images/ProjStone.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.ProjStone;
                }
                if (Type2 == 1) {
                    if (this.ProjBall == null) {
                        try {
                            this.ProjBall = Image.createImage((String)"/Images/ProjBall.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.ProjBall;
                }
                if (Type2 == 2) {
                    if (this.Bomerang == null) {
                        try {
                            this.Bomerang = Image.createImage((String)"/Images/Bomerang1.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.Bomerang;
                }
                if (Type2 == 3) {
                    if (this.ProjArrow == null) {
                        try {
                            this.ProjArrow = Image.createImage((String)"/Images/Arrows.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.ProjArrow;
                }
                if (Type2 == 4) {
                    if (this.HookshotPic == null) {
                        try {
                            this.HookshotPic = Image.createImage((String)"/Images/HookShot.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.HookshotPic;
                }
                if (Type2 == 5) {
                    if (this.WandShot == null) {
                        try {
                            this.WandShot = Image.createImage((String)"/Images/WandShot01.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin item img");
                            return null;
                        }
                    }
                    return this.WandShot;
                }
                if (Type2 != 6) break block29;
                if (this.WandShot == null) {
                    try {
                        this.WandShot = Image.createImage((String)"/Images/Smoke01.png");
                    }
                    catch (IOException e) {
                        System.out.println("error loadin item img");
                        return null;
                    }
                }
                return this.WandShot;
            }
            catch (OutOfMemoryError e) {
                this.BasePic = null;
                System.out.println("Error... out of memory");
                System.gc();
                return this.GetItemGfx(Type2);
            }
        }
        return null;
    }

    Image GetEventGfx(int Type2) {
        block181: {
            try {
                if (Type2 == 3) {
                    if (this.Bush == null) {
                        try {
                            this.Bush = Image.createImage((String)"/Images/Bush.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Bush;
                }
                if (Type2 == 4) {
                    if (this.Bush == null) {
                        try {
                            this.Bush = Image.createImage((String)"/Images/TealBush.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Bush;
                }
                if (Type2 == 5) {
                    if (this.Const == null) {
                        try {
                            this.Const = Image.createImage((String)"/Images/const1.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Const;
                }
                if (Type2 == 6) {
                    if (this.Flowers == null) {
                        try {
                            this.Flowers = Image.createImage((String)"/Images/GreenFlowers.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Flowers;
                }
                if (Type2 == 7) {
                    if (this.Flowers == null) {
                        try {
                            this.Flowers = Image.createImage((String)"/Images/TealFlowers.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Flowers;
                }
                if (Type2 == 8) {
                    if (this.Candle1 == null) {
                        try {
                            this.Candle1 = Image.createImage((String)"/Images/Candle1.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Candle1;
                }
                if (Type2 == 9) {
                    if (this.Waterfall1 == null) {
                        try {
                            this.Waterfall1 = Image.createImage((String)"/Images/Waterfall02.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Waterfall1;
                }
                if (Type2 == 10) {
                    if (this.Waterfall2 == null) {
                        try {
                            this.Waterfall2 = Image.createImage((String)"/Images/Waterfall01.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Waterfall2;
                }
                if (Type2 == 11) {
                    if (this.Candle2 == null) {
                        try {
                            this.Candle2 = Image.createImage((String)"/Images/Candle2.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Candle2;
                }
                if (Type2 == 12) {
                    if (this.Grave == null) {
                        try {
                            this.Grave = Image.createImage((String)"/Images/Gravestone.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Grave;
                }
                if (Type2 == 13 || Type2 == 14) {
                    if (this.Fence == null) {
                        try {
                            this.Fence = Image.createImage((String)"/Images/Fence.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Fence;
                }
                if (Type2 == 15) {
                    if (this.Bush == null) {
                        try {
                            this.Bush = Image.createImage((String)"/Images/BrownBush.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Bush;
                }
                if (Type2 == 16) {
                    if (this.Sign == null) {
                        try {
                            this.Sign = Image.createImage((String)"/Images/Sign.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Sign;
                }
                if (Type2 == 19) {
                    if (this.Flowers == null) {
                        try {
                            this.Flowers = Image.createImage((String)"/Images/HappyFlowers.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Flowers;
                }
                if (Type2 == 20) {
                    if (this.HookTarget == null) {
                        try {
                            this.HookTarget = Image.createImage((String)"/Images/HookTarget.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.HookTarget;
                }
                if (Type2 >= 21 && Type2 <= 24) {
                    if (this.Brygga == null) {
                        try {
                            this.Brygga = Image.createImage((String)"/Images/Brygga.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Brygga;
                }
                if (Type2 == 25) {
                    if (this.Water == null) {
                        try {
                            this.Water = Image.createImage((String)"/Images/GreenWaterTest01.png");
                            System.out.println("Loaded " + Type2);
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Water;
                }
                if (Type2 >= 26 && Type2 <= 27) {
                    if (this.Net == null) {
                        try {
                            this.Net = Image.createImage((String)"/Images/Bridge.png");
                            System.out.println("Loaded " + Type2);
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Net;
                }
                if (Type2 == 28) {
                    if (this.Water == null) {
                        try {
                            this.Water = Image.createImage((String)"/Images/WaterTest01.png");
                            System.out.println("Loaded " + Type2);
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Water;
                }
                if (Type2 == 29) {
                    if (this.Water == null) {
                        try {
                            this.Water = Image.createImage((String)"/Images/Pedestal.png");
                            System.out.println("Loaded " + Type2);
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Water;
                }
                if (Type2 == 32) {
                    if (this.Pushable == null) {
                        try {
                            this.Pushable = Image.createImage((String)"/Images/Stone.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Pushable;
                }
                if (Type2 >= 34 && Type2 <= 42) {
                    if (this.Net == null) {
                        try {
                            this.Net = Image.createImage((String)"/Images/Net.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Net;
                }
                if (Type2 >= 43 && Type2 <= 45) {
                    if (this.Stairs == null) {
                        try {
                            this.Stairs = Image.createImage((String)"/Images/Stairs.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Stairs;
                }
                if (Type2 == 46) {
                    if (this.Pushable == null) {
                        try {
                            this.Pushable = Image.createImage((String)"/Images/Stone.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Pushable;
                }
                if (Type2 == 48) {
                    if (this.Trigger == null) {
                        try {
                            this.Trigger = Image.createImage((String)"/Images/Trigger01.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Trigger;
                }
                if (Type2 >= 52 && Type2 <= 59) {
                    if (this.Trigger == null) {
                        try {
                            this.Trigger = Image.createImage((String)"/Images/Claws.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Trigger;
                }
                if (Type2 == 60) {
                    if (this.Trigger == null) {
                        try {
                            this.Trigger = Image.createImage((String)"/Images/WallEye.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Trigger;
                }
                if (Type2 == 61) {
                    if (this.Trigger == null) {
                        try {
                            this.Trigger = Image.createImage((String)"/Images/Monster10.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Trigger;
                }
                if (Type2 >= 64 && Type2 <= 67) {
                    if (this.Door == null) {
                        try {
                            this.Door = Image.createImage((String)"/Images/Dungeon Doors.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Door;
                }
                if (Type2 >= 68 && Type2 <= 71) {
                    if (this.Door2 == null) {
                        try {
                            this.Door2 = Image.createImage((String)"/Images/Dungeon Doors 2.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Door2;
                }
                if (Type2 >= 72 && Type2 <= 75) {
                    if (this.Wall == null) {
                        try {
                            this.Wall = Image.createImage((String)"/Images/Wall.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Wall;
                }
                if (Type2 >= 104 && Type2 <= 107) {
                    if (this.Wall == null) {
                        try {
                            this.Wall = Image.createImage((String)"/Images/Wall2.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Wall;
                }
                if (Type2 >= 120 && Type2 <= 123) {
                    if (this.Wall == null) {
                        try {
                            this.Wall = Image.createImage((String)"/Images/Wall3.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Wall;
                }
                if (Type2 == 76) {
                    if (this.BombWall == null) {
                        try {
                            this.BombWall = Image.createImage((String)"/Images/BombWall.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.BombWall;
                }
                if (Type2 >= 96 && Type2 <= 99) {
                    if (this.Door == null) {
                        try {
                            this.Door = Image.createImage((String)"/Images/Dungeon Doors 3.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Door;
                }
                if (Type2 >= 100 && Type2 <= 103) {
                    if (this.Door2 == null) {
                        try {
                            this.Door2 = Image.createImage((String)"/Images/Dungeon Doors 4.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Door2;
                }
                if (Type2 >= 112 && Type2 <= 115) {
                    if (this.Door == null) {
                        try {
                            this.Door = Image.createImage((String)"/Images/Dungeon Doors 5.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Door;
                }
                if (Type2 >= 116 && Type2 <= 119) {
                    if (this.Door2 == null) {
                        try {
                            this.Door2 = Image.createImage((String)"/Images/Dungeon Doors 6.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Door2;
                }
                if (Type2 >= 128 && Type2 <= 131) {
                    if (this.Door == null) {
                        try {
                            this.Door = Image.createImage((String)"/Images/Dungeon Doors 7.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Door;
                }
                if (Type2 >= 132 && Type2 <= 135) {
                    if (this.Door2 == null) {
                        try {
                            this.Door2 = Image.createImage((String)"/Images/Dungeon Doors 8.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Door2;
                }
                if (Type2 >= 144 && Type2 <= 147) {
                    if (this.Door == null) {
                        try {
                            this.Door = Image.createImage((String)"/Images/Dungeon Doors 10.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Door;
                }
                if (Type2 >= 148 && Type2 <= 151) {
                    if (this.Door2 == null) {
                        try {
                            this.Door2 = Image.createImage((String)"/Images/Dungeon Doors 9.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.Door2;
                }
                if (Type2 >= 80 && Type2 <= 83) {
                    if (this.BombTree == null) {
                        try {
                            this.BombTree = Image.createImage((String)"/Images/GreenBombTree.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.BombTree;
                }
                if (Type2 >= 84 && Type2 <= 87) {
                    if (this.BombTree == null) {
                        try {
                            this.BombTree = Image.createImage((String)"/Images/TealBombTree.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Event img");
                            return null;
                        }
                    }
                    return this.BombTree;
                }
                if (Type2 < 88 || Type2 > 91) break block181;
                if (this.BombTree == null) {
                    try {
                        this.BombTree = Image.createImage((String)"/Images/BehindTree01.png");
                    }
                    catch (IOException e) {
                        System.out.println("error loadin Event img");
                        return null;
                    }
                }
                return this.BombTree;
            }
            catch (OutOfMemoryError e) {
                this.BasePic = null;
                System.out.println("Error... out of memory");
                System.gc();
                return this.GetItemGfx(Type2);
            }
        }
        return null;
    }

    Image GetMonsterGfx(int Type2) {
        block101: {
            try {
                if (Type2 == 0) {
                    if (this.OctoGfx == null) {
                        try {
                            this.OctoGfx = Image.createImage((String)"/Images/Octo2.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.OctoGfx;
                }
                if (Type2 == 1) {
                    if (this.Fire == null) {
                        try {
                            this.Fire = Image.createImage((String)"/Images/Fire.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Fire;
                }
                if (Type2 == 2) {
                    if (this.Jumpy == null) {
                        try {
                            this.Jumpy = Image.createImage((String)"/Images/Monster3.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Jumpy;
                }
                if (Type2 == 3) {
                    if (this.Diggy == null) {
                        try {
                            this.Diggy = Image.createImage((String)"/Images/Monster4.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Diggy;
                }
                if (Type2 == 4) {
                    if (this.Bat == null) {
                        try {
                            this.Bat = Image.createImage((String)"/Images/Monster5.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Bat;
                }
                if (Type2 == 5) {
                    if (this.Skele == null) {
                        try {
                            this.Skele = Image.createImage((String)"/Images/Monster6.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Skele;
                }
                if (Type2 == 6) {
                    if (this.Teddy == null) {
                        try {
                            this.Teddy = Image.createImage((String)"/Images/Monster7.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Teddy;
                }
                if (Type2 == 7) {
                    if (this.Worm == null) {
                        try {
                            this.Worm = Image.createImage((String)"/Images/Monster8.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Worm;
                }
                if (Type2 == 8) {
                    if (this.Worm2 == null) {
                        try {
                            this.Worm2 = Image.createImage((String)"/Images/Moldorm.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Worm2;
                }
                if (Type2 == 9) {
                    if (this.Spike == null) {
                        try {
                            this.Spike = Image.createImage((String)"/Images/Monster10.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Spike;
                }
                if (Type2 == 10) {
                    if (this.Knight == null) {
                        try {
                            this.Knight = Image.createImage((String)"/Images/Monster11.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Knight;
                }
                if (Type2 == 11) {
                    if (this.Slime == null) {
                        try {
                            this.Slime = Image.createImage((String)"/Images/Monster12.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Slime;
                }
                if (Type2 == 12) {
                    if (this.Moblin == null) {
                        try {
                            this.Moblin = Image.createImage((String)"/Images/Monster13.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Moblin;
                }
                if (Type2 == 13) {
                    if (this.Moblin == null) {
                        try {
                            this.Moblin = Image.createImage((String)"/Images/Monster16.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Moblin;
                }
                if (Type2 == 14) {
                    if (this.Ghost == null) {
                        try {
                            this.Ghost = this.Parent.UseAlpha ? Image.createImage((String)"/Images/Ghost2.png") : Image.createImage((String)"/Images/Ghost2-2.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Ghost;
                }
                if (Type2 == 15) {
                    if (this.Mummy == null) {
                        try {
                            this.Mummy = Image.createImage((String)"/Images/Monster19.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Mummy;
                }
                if (Type2 == 16) {
                    if (this.Boss == null) {
                        try {
                            this.Boss = Image.createImage((String)"/Images/Boss1.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Boss;
                }
                if (Type2 == 17) {
                    if (this.Boss == null) {
                        try {
                            this.Boss = Image.createImage((String)"/Images/Boss2-2.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Boss;
                }
                if (Type2 == 18) {
                    if (this.Boss == null) {
                        try {
                            this.Boss = Image.createImage((String)"/Images/Boss3.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Boss;
                }
                if (Type2 == 19) {
                    if (this.Ghost == null) {
                        try {
                            this.Ghost = Image.createImage((String)"/Images/Monster18.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Ghost;
                }
                if (Type2 == 20) {
                    if (this.Boss == null) {
                        try {
                            this.Boss = Image.createImage((String)"/Images/Boss4-2.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Boss;
                }
                if (Type2 == 21) {
                    if (this.Boss == null) {
                        try {
                            this.Boss = this.Parent.UseAlpha ? Image.createImage((String)"/Images/Boss5-2.png") : Image.createImage((String)"/Images/Boss5-3.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Boss;
                }
                if (Type2 == 22) {
                    if (this.Boss == null) {
                        try {
                            this.Boss = Image.createImage((String)"/Images/Boss6.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.Boss;
                }
                if (Type2 >= 128 && Type2 <= 130) {
                    if (this.NPC == null) {
                        try {
                            this.NPC = Image.createImage((String)"/Images/Monster128-130.png");
                        }
                        catch (IOException e) {
                            System.out.println("error loadin Map img");
                            return null;
                        }
                    }
                    return this.NPC;
                }
                if (Type2 != 131) break block101;
                if (this.Moblin == null) {
                    try {
                        this.Moblin = Image.createImage((String)"/Images/Monster13.png");
                    }
                    catch (IOException e) {
                        System.out.println("error loadin Map img");
                        return null;
                    }
                }
                return this.Moblin;
            }
            catch (OutOfMemoryError e) {
                this.BasePic = null;
                System.out.println("Error... out of memory");
                System.gc();
                return this.GetMonsterGfx(Type2);
            }
        }
        return null;
    }

    boolean DropBomb(player p) {
        if (p.Bombs > 0) {
            int Type2 = 4;
            int TempPosX = 0;
            int TempPosY = 0;
            if (p.Dir == 0) {
                TempPosY = -8;
            }
            if (p.Dir == 1) {
                TempPosX = 16;
            }
            if (p.Dir == 2) {
                TempPosY = 16;
            }
            if (p.Dir == 3) {
                TempPosX = -8;
            }
            Item TempI = new Item(this.GetItemGfx(Type2), Type2, p.PosX + TempPosX, p.PosY + TempPosY - 32, 1);
            this.Items.addElement(TempI);
            p.Bombs = (byte)(p.Bombs - 1);
            return true;
        }
        return false;
    }

    void ThrowBomerang(player p) {
        if (!p.BomerangWait) {
            int TempX = 0;
            int TempY = 0;
            if (p.Dir == 0) {
                TempY = -1;
            }
            if (p.Dir == 1) {
                TempX = 1;
            }
            if (p.Dir == 2) {
                TempY = 1;
            }
            if (p.Dir == 3) {
                TempX = -1;
            }
            Projectile TempP = new Projectile(this.GetProjGfx(2), 2, TempX, TempY);
            TempP.PosX = p.PosX + 8 + 12 * TempX;
            TempP.PosY = p.PosY + 12 + 16 * TempY;
            p.BomerangWait = true;
            TempP.Hostile = false;
            this.Projectiles.addElement(TempP);
            p.frame = 6;
        }
    }

    void UseHookshot(player p) {
        int TempHookshot = 0;
        if (p.HookShotWait != 0) {
            return;
        }
        if (p.HookShot) {
            if (!p.HookShotReturn) {
                Cords2 Temp2;
                Cords2 Temp = new Cords2();
                if (p.HookShotCords.size() == 0) {
                    Temp2 = new Cords2();
                    if (p.Dir == 0) {
                        Temp2.PosX = p.PosX + 8;
                        Temp2.PosY = p.PosY + 8;
                    }
                    if (p.Dir == 1) {
                        Temp2.PosX = p.PosX + 12;
                        Temp2.PosY = p.PosY + 12;
                    }
                    if (p.Dir == 2) {
                        Temp2.PosX = p.PosX + 8;
                        Temp2.PosY = p.PosY + 12;
                    }
                    if (p.Dir == 3) {
                        Temp2.PosX = p.PosX + 12;
                        Temp2.PosY = p.PosY + 8;
                    }
                } else {
                    Temp2 = (Cords2)p.HookShotCords.elementAt(p.HookShotCords.size() - 1);
                }
                if (p.Dir == 0) {
                    Temp.PosY = Temp2.PosY - 8;
                    Temp.PosX = Temp2.PosX;
                }
                if (p.Dir == 1) {
                    Temp.PosY = Temp2.PosY;
                    Temp.PosX = Temp2.PosX + 8;
                }
                if (p.Dir == 2) {
                    Temp.PosY = Temp2.PosY + 8;
                    Temp.PosX = Temp2.PosX;
                }
                if (p.Dir == 3) {
                    Temp.PosY = Temp2.PosY;
                    Temp.PosX = Temp2.PosX - 8;
                }
                if ((TempHookshot = this.GetHookCol(Temp.PosX, Temp.PosY, p)) == 0) {
                    p.HookShotCords.addElement(Temp);
                    if (p.HookShotCords.size() > 12) {
                        p.HookShotReturn = true;
                    }
                } else {
                    if (TempHookshot == 2) {
                        p.PlayerAndHookShotReturn = true;
                    }
                    p.HookShotReturn = true;
                }
            } else if (p.HookShotCords.size() > 0) {
                Cords2 Temp2 = (Cords2)p.HookShotCords.elementAt(p.HookShotCords.size() - 1);
                this.GetHookCol(Temp2.PosX, Temp2.PosY, p);
                if (!p.PlayerAndHookShotReturn) {
                    p.HookShotCords.removeElementAt(p.HookShotCords.size() - 1);
                } else {
                    Cords2 Temp = (Cords2)p.HookShotCords.elementAt(0);
                    p.PosX = Temp.PosX;
                    p.PosY = Temp.PosY;
                    if (p.Dir == 0) {
                        p.PosX -= 8;
                        p.PosY -= 8;
                    }
                    if (p.Dir == 1) {
                        p.PosX -= 4;
                        p.PosY -= 12;
                    }
                    if (p.Dir == 2) {
                        p.PosX -= 8;
                        p.PosY -= 12;
                    }
                    if (p.Dir == 3) {
                        p.PosX -= 12;
                        p.PosY -= 8;
                    }
                    p.HookShotCords.removeElementAt(0);
                }
                if (p.HookShotCords.size() == 0) {
                    p.HookShot = false;
                    p.HookShotCords.removeAllElements();
                    p.HookShotReturn = false;
                    p.HookShotWait = 0;
                    p.PlayerAndHookShotReturn = false;
                }
            } else {
                p.HookShot = false;
                p.HookShotCords.removeAllElements();
                p.HookShotReturn = false;
                p.HookShotWait = 0;
                p.PlayerAndHookShotReturn = false;
            }
        }
    }

    int GetHookCol(int X, int Y, player p) {
        byte Temp;
        int PickUp = 0;
        int x = X;
        int y = Y;
        int pos = 0;
        int boundX = 0;
        int boundY = 0;
        int LastX = 0;
        int LastY = 0;
        int OffsY = 0;
        int OffsX = 0;
        if (p.Dir == 0) {
            y -= 4;
            boundX = 12;
            boundY = 8;
            LastY = 8;
        }
        if (p.Dir == 1) {
            x += 4;
            boundX = 8;
            boundY = 12;
            LastX = -8;
        }
        if (p.Dir == 2) {
            y += 4;
            boundX = 12;
            boundY = 8;
            LastY = -8;
        }
        if (p.Dir == 3) {
            x -= 4;
            boundX = 8;
            boundY = 12;
            LastX = 8;
        }
        if ((pos = (y + OffsY - 32 >> 4) * this.Xsize + (x + OffsX >> 4)) <= this.Xsize * this.Ysize && pos > 0 && ((Temp = this.TileMap[pos]) & 0x40) == 64) {
            return 1;
        }
        int i = 0;
        while (i < this.Items.size()) {
            Item TempI = (Item)this.Items.elementAt(i);
            if (TempI.PosX <= x + boundX && TempI.PosX + TempI.MiddleX * 2 >= x && TempI.PosY <= y + boundY && TempI.PosY + TempI.MiddleY * 2 >= y && TempI.Type < 128) {
                TempI.PosX += LastX;
                TempI.PosY += LastY;
                PickUp = 1;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.Monsters.size()) {
            Monster TempM = (Monster)this.Monsters.elementAt(i2);
            if (TempM.CanBeKilled && !TempM.Dead && TempM.PosX <= x + boundX && TempM.PosX + TempM.SizeX >= x && TempM.PosY <= y + boundY && TempM.PosY + TempM.SizeY >= y) {
                if (TempM.Type != 16 && TempM.Type != 17 && TempM.Type != 18 && TempM.Type != 19 && TempM.Type != 20 && TempM.Type != 21) {
                    TempM.PosX += LastX;
                    TempM.PosY += LastY;
                    PickUp = 1;
                } else {
                    PickUp = 2;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.Events.size()) {
            Event TempE = (Event)this.Events.elementAt(i3);
            if (TempE.PosX <= x + boundX && TempE.PosX + 16 >= x && TempE.PosY <= y + boundY && TempE.PosY + 16 >= y) {
                if (TempE.GfxType == 20) {
                    PickUp = 2;
                    Cords2 Temp2 = (Cords2)p.HookShotCords.elementAt(p.HookShotCords.size() - 1);
                    if (p.Dir == 0) {
                        Temp2.PosY = TempE.PosY + 16;
                    }
                    if (p.Dir == 1) {
                        Temp2.PosX = TempE.PosX - 16;
                    }
                    if (p.Dir == 2) {
                        Temp2.PosY = TempE.PosY - 16;
                    }
                    if (p.Dir == 3) {
                        Temp2.PosX = TempE.PosX + 20;
                    }
                } else if (TempE.Solid && TempE.Active) {
                    return 1;
                }
            }
            ++i3;
        }
        return PickUp;
    }

    boolean ShootArrow(player p) {
        if (p.Arrows > 0) {
            p.Arrows = (byte)(p.Arrows - 1);
            int TempY = 0;
            int TempX = 0;
            if (p.Dir == 0) {
                TempY = -1;
            }
            if (p.Dir == 1) {
                TempX = 1;
            }
            if (p.Dir == 2) {
                TempY = 1;
            }
            if (p.Dir == 3) {
                TempX = -1;
            }
            Projectile TempP = new Projectile(this.GetProjGfx(3), 3, TempX, TempY);
            TempP.PosX = p.PosX + 8 + 12 * TempX;
            TempP.PosY = p.PosY + 12 + 16 * TempY;
            TempP.Hostile = false;
            this.Projectiles.addElement(TempP);
            return true;
        }
        return false;
    }

    boolean DrawProjectiles(Graphics g2, int TileXOffset, int TileYOffset, int width, int height, player p, MeidaPlayer Mp) {
        boolean ret = false;
        int i = 0;
        while (i < this.Projectiles.size()) {
            block68: {
                Projectile TempP;
                block72: {
                    block73: {
                        block76: {
                            block75: {
                                block74: {
                                    byte Temp;
                                    block71: {
                                        block70: {
                                            block69: {
                                                block67: {
                                                    TempP = (Projectile)this.Projectiles.elementAt(i);
                                                    if (TempP.PosX <= 256) break block67;
                                                    if (TempP.Type == 2) {
                                                        if (TempP.Hostile) {
                                                            ((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).ShotWait = false;
                                                        } else {
                                                            p.BomerangWait = false;
                                                        }
                                                    }
                                                    this.Projectiles.removeElementAt(i);
                                                    break block68;
                                                }
                                                if (TempP.PosX >= 0) break block69;
                                                if (TempP.Type == 2) {
                                                    if (TempP.Hostile) {
                                                        ((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).ShotWait = false;
                                                    } else {
                                                        p.BomerangWait = false;
                                                    }
                                                }
                                                this.Projectiles.removeElementAt(i);
                                                break block68;
                                            }
                                            if (TempP.PosY <= 208) break block70;
                                            if (TempP.Type == 2) {
                                                if (TempP.Hostile) {
                                                    ((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).ShotWait = false;
                                                } else {
                                                    p.BomerangWait = false;
                                                }
                                            }
                                            this.Projectiles.removeElementAt(i);
                                            break block68;
                                        }
                                        if (TempP.PosY >= 32) break block71;
                                        if (TempP.Type == 2) {
                                            if (TempP.Hostile) {
                                                ((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).ShotWait = false;
                                            } else {
                                                p.BomerangWait = false;
                                            }
                                        }
                                        this.Projectiles.removeElementAt(i);
                                        break block68;
                                    }
                                    int pos = 0;
                                    pos = (TempP.PosY - 32 >> 4) * this.Xsize + (TempP.PosX >> 4);
                                    if (pos <= this.Xsize * this.Ysize && pos > 0 && ((Temp = this.TileMap[pos]) & 0x40) == 64) {
                                        if (TempP.Type != 2) {
                                            if (TempP.Type != 3 && TempP.Type != 5) {
                                                this.Projectiles.removeElementAt(i);
                                            }
                                        } else if (!TempP.Returning) {
                                            TempP.Xinc = -TempP.Xinc;
                                            TempP.Yinc = -TempP.Yinc;
                                            TempP.Returning = true;
                                        }
                                    }
                                    if (TempP.Returning) {
                                        if (TempP.Hostile) {
                                            try {
                                                if (((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).PosX <= TempP.PosX + 5 && ((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).PosX + 16 >= TempP.PosX + 5 && ((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).PosY <= TempP.PosY + 5 && ((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).PosY + 16 >= TempP.PosY + 5) {
                                                    this.Projectiles.removeElementAt(i);
                                                    ((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).ShotWait = false;
                                                }
                                                if (((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).PosX + 8 > TempP.PosX + 5) {
                                                    TempP.Xinc = 1;
                                                }
                                                if (((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).PosY + 8 > TempP.PosY + 5) {
                                                    TempP.Yinc = 1;
                                                }
                                                if (((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).PosX + 8 < TempP.PosX + 5) {
                                                    TempP.Xinc = -1;
                                                }
                                                if (((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).PosY + 8 < TempP.PosY + 5) {
                                                    TempP.Yinc = -1;
                                                }
                                                if (((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).PosX + 8 == TempP.PosX + 5) {
                                                    TempP.Xinc = 0;
                                                }
                                                if (((Monster)this.Monsters.elementAt((int)TempP.ReturnTo)).PosY + 8 == TempP.PosY + 5) {
                                                    TempP.Yinc = 0;
                                                }
                                            }
                                            catch (ArrayIndexOutOfBoundsException e) {
                                                this.Projectiles.removeElementAt(i);
                                            }
                                        } else {
                                            if (p.PosX - 1 <= TempP.PosX + 5 && p.PosX + 16 >= TempP.PosX + 5 && p.PosY - 1 <= TempP.PosY + 5 && p.PosY + 24 >= TempP.PosY + 5) {
                                                p.BomerangWait = false;
                                                this.Projectiles.removeElementAt(i);
                                            }
                                            if (p.PosX + 8 > TempP.PosX + 5) {
                                                TempP.Xinc = 1;
                                            }
                                            if (p.PosY + 8 > TempP.PosY + 5) {
                                                TempP.Yinc = 1;
                                            }
                                            if (p.PosX + 8 < TempP.PosX + 5) {
                                                TempP.Xinc = -1;
                                            }
                                            if (p.PosY + 8 < TempP.PosY + 5) {
                                                TempP.Yinc = -1;
                                            }
                                            if (p.PosX + 8 == TempP.PosX + 5) {
                                                TempP.Xinc = 0;
                                            }
                                            if (p.PosY + 8 == TempP.PosY + 5) {
                                                TempP.Yinc = 0;
                                            }
                                        }
                                    }
                                    TempP.Draw(g2, TileXOffset, TileYOffset, width, height);
                                    if (!TempP.Hostile) break block72;
                                    if (p.PosX > TempP.PosX || p.PosX + 16 < TempP.PosX || p.PosY > TempP.PosY || p.PosY + 24 < TempP.PosY) break block68;
                                    if (!p.Shield) break block73;
                                    if (TempP.dir != 0 || p.Dir != 2) break block74;
                                    if (TempP.Type != 5) {
                                        this.Projectiles.removeElementAt(i);
                                    } else {
                                        TempP.Hostile = false;
                                        TempP.Xinc = -TempP.Xinc;
                                        TempP.Yinc = -TempP.Yinc;
                                        TempP.Damage *= 2;
                                    }
                                    break block68;
                                }
                                if (TempP.dir != 1 || p.Dir != 3) break block75;
                                if (TempP.Type != 5) {
                                    this.Projectiles.removeElementAt(i);
                                } else {
                                    TempP.Hostile = false;
                                    TempP.Xinc = -TempP.Xinc;
                                    TempP.Yinc = -TempP.Yinc;
                                    TempP.Damage *= 2;
                                }
                                break block68;
                            }
                            if (TempP.dir != 2 || p.Dir != 0) break block76;
                            if (TempP.Type != 5) {
                                this.Projectiles.removeElementAt(i);
                            } else {
                                TempP.Hostile = false;
                                TempP.Xinc = -TempP.Xinc;
                                TempP.Yinc = -TempP.Yinc;
                                TempP.Damage *= 2;
                            }
                            break block68;
                        }
                        if (TempP.dir != 3 || p.Dir != 1) break block73;
                        if (TempP.Type != 5) {
                            this.Projectiles.removeElementAt(i);
                        } else {
                            TempP.Hostile = false;
                            TempP.Damage *= 2;
                            TempP.Xinc = -TempP.Xinc;
                            TempP.Yinc = -TempP.Yinc;
                        }
                        break block68;
                    }
                    if (p.HitRecovery > 0) break block68;
                    p.HitRecovery = 20;
                    p.Life -= TempP.Damage / p.DamageModifier + 1;
                    if (p.Life < 0) {
                        p.Life = 0;
                    }
                    if (TempP.Type != 2) {
                        this.Projectiles.removeElementAt(i);
                    } else if (!TempP.Returning) {
                        TempP.Xinc = -TempP.Xinc;
                        TempP.Yinc = -TempP.Yinc;
                        TempP.Returning = true;
                    }
                    ret = true;
                    break block68;
                }
                int j = 0;
                while (j < this.Monsters.size()) {
                    block77: {
                        block78: {
                            Monster TempM;
                            block80: {
                                block79: {
                                    TempM = (Monster)this.Monsters.elementAt(j);
                                    if (!TempM.CanBeKilled && TempM.Type != 22 || TempM.Dead || TempM.PosX > TempP.PosX + 10 || TempM.PosX + TempM.SizeX < TempP.PosX || TempM.PosY > TempP.PosY + 10 || TempM.PosY + TempM.SizeY < TempP.PosY) break block77;
                                    if (TempM.Hitrecovery > 0) break block78;
                                    if (TempM.Type != 10) break block79;
                                    if (TempP.Type == 3) {
                                        --TempM.Life;
                                    }
                                    break block80;
                                }
                                if (TempM.Type == 17) break block77;
                                TempM.Life -= TempP.Damage;
                            }
                            if (TempM.Life <= 0) {
                                TempM.DeathCounter = 0;
                                TempM.Dead = true;
                                TempM.Gfx = this.Death;
                                TempM.Frame = 0;
                            } else {
                                TempM.Hitrecovery = 10;
                            }
                        }
                        if (TempP.Type != 2) {
                            if (TempP.Type != 3 && TempP.Type != 5) {
                                this.Projectiles.removeElementAt(i);
                            }
                        } else if (!TempP.Returning) {
                            TempP.Xinc = -TempP.Xinc;
                            TempP.Yinc = -TempP.Yinc;
                            TempP.Returning = true;
                        }
                    }
                    ++j;
                }
                int j2 = 0;
                while (j2 < this.Items.size()) {
                    Item TempI = (Item)this.Items.elementAt(j2);
                    if (TempI.PosX <= TempP.PosX + 10 && TempI.PosX + 5 >= TempP.PosX && TempI.PosY <= TempP.PosY + 10 && TempI.PosY + 5 >= TempP.PosY && TempI.Type < 4 && TempI.PickUp(p, Mp)) {
                        this.Items.removeElementAt(j2);
                        ret = true;
                    }
                    ++j2;
                }
                if (TempP.Type == 3) {
                    int j3 = 0;
                    while (j3 < this.Events.size()) {
                        Event TempE = (Event)this.Events.elementAt(j3);
                        if (TempE.PosX <= TempP.PosX + 10 && TempE.PosX + 5 >= TempP.PosX && TempE.PosY <= TempP.PosY + 10 && TempE.PosY + 5 >= TempP.PosY && TempE.GfxType == 60) {
                            TempE.Trigged = true;
                        }
                        ++j3;
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    boolean ShowEventText(int event, Graphics g, int width, int height) {
        Event TempE = (Event)this.Events.elementAt(event);
        if (TempE.Text > 0) {
            g.translate(-g.getTranslateX(), -g.getTranslateY());
            g.setColor(0);
            g.setClip(0, 0, width, height);
            g.fillRect(10, height / 3 * 2 - 48 + 32, width - 20, 40);
            g.setColor(0xFFFFFF);
            g.drawRect(10, height / 3 * 2 - 48 + 32, width - 20, 40);
            g.setColor(0xAAAAAA);
            g.drawRect(11, height / 3 * 2 - 47 + 32, width - 22, 38);
            g.setColor(0xFFFFFF);
            g.translate(15, height / 3 * 2 - 44 + 32);
            Font f = g.getFont();
            int strlen = f.stringWidth((String)this.Strings.elementAt(TempE.StringIndex));
            if (strlen > width - 32) {
                int strlen2 = ((String)this.Strings.elementAt(TempE.StringIndex)).length();
                int len = strlen2 - 1;
                while (f.substringWidth((String)this.Strings.elementAt(TempE.StringIndex), 0, len) > width - 32) {
                    --len;
                }
                g.drawSubstring((String)this.Strings.elementAt(TempE.StringIndex), 0, len, 0, 0, 0x10 | 4);
                g.translate(0, f.getHeight());
                g.drawSubstring((String)this.Strings.elementAt(TempE.StringIndex), len, strlen2 - len - 1, 0, 0, 0x10 | 4);
            } else {
                g.drawString((String)this.Strings.elementAt(TempE.StringIndex), 0, 0, 0x10 | 4);
            }
        }
        return true;
    }

    boolean ShowTextMessage(String text, Graphics g, int width, int height) {
        g.translate(-g.getTranslateX(), -g.getTranslateY());
        g.setColor(0);
        g.setClip(0, 0, width, height);
        g.fillRect(10, height / 3 * 2 - 48 + 32, width - 20, 40);
        g.setColor(0xFFFFFF);
        g.drawRect(10, height / 3 * 2 - 48 + 32, width - 20, 40);
        g.setColor(0xAAAAAA);
        g.drawRect(11, height / 3 * 2 - 47 + 32, width - 22, 38);
        g.setColor(0xFFFFFF);
        g.translate(15, height / 3 * 2 - 44 + 32);
        Font f = g.getFont();
        int strlen = f.stringWidth(text);
        if (strlen > width - 32) {
            int strlen2 = text.length();
            int len = strlen2 - 1;
            while (f.substringWidth(text, 0, len) > width - 32) {
                --len;
            }
            g.drawSubstring(text, 0, len, 0, 0, 0x10 | 4);
            g.translate(0, f.getHeight());
            g.drawSubstring(text, len, strlen2 - len - 1, 0, 0, 0x10 | 4);
        } else {
            g.drawString(text, 0, 0, 0x10 | 4);
        }
        return true;
    }

    boolean Test(String s, Graphics g, player p, int CurrentMap, int CurrentWorld, int xsize, int ysize, boolean NotIntro) {
        this.ScreenHeight = ysize;
        this.ScreenWidth = xsize;
        System.out.println("Load Map" + s);
        try {
            byte[] Tag = new byte[4];
            byte TilesetTemp = 0;
            InputStream is = this.getClass().getResourceAsStream(s);
            if (is == null) {
                System.out.println("File Not Found");
                return false;
            }
            DataInputStream dis = new DataInputStream(is);
            dis.read(Tag, 0, 4);
            if (Tag[0] == 88) {
                int NumberOfMonsters;
                VisitedMap TempMap1 = new VisitedMap();
                TempMap1.World = this.CurrentWorldNumber;
                TempMap1.Map = this.CurrentMapNumber;
                TempMap1.Monsters = this.Monsters.size();
                this.VisitedMaps.addElement(TempMap1);
                if (this.VisitedMaps.size() > 16) {
                    this.VisitedMaps.removeElementAt(0);
                }
                this.MapMonsterType = 0;
                this.Monsters.removeAllElements();
                this.Items.removeAllElements();
                this.Warp.removeAllElements();
                this.Events.removeAllElements();
                this.EventsLevel2.removeAllElements();
                this.Strings.removeAllElements();
                this.Projectiles.removeAllElements();
                this.CurrentMapNumber = CurrentMap;
                this.CurrentWorldNumber = CurrentWorld;
                if (NotIntro) {
                    p.BomerangWait = false;
                }
                this.OctoGfx = null;
                this.OctoGfx2 = null;
                this.Death = null;
                this.NPC = null;
                this.Fire = null;
                this.Ghost = null;
                this.SwordHearts = null;
                this.Item57 = null;
                this.Item134136 = null;
                this.Item137139 = null;
                this.Item140142 = null;
                this.Pushable = null;
                this.Trigger = null;
                this.Door = null;
                this.Door2 = null;
                this.Jumpy = null;
                this.Diggy = null;
                this.Bat = null;
                this.KeysNStuff = null;
                this.Boss = null;
                this.Skele = null;
                this.Teddy = null;
                this.Mummy = null;
                this.Stairs = null;
                this.Water = null;
                this.Slime = null;
                this.Knight = null;
                this.Moblin = null;
                this.Worm = null;
                this.Worm2 = null;
                this.Spike = null;
                this.Wall = null;
                this.Bomb = null;
                this.Bush = null;
                this.BombWall = null;
                this.BombTree = null;
                this.ProjStone = null;
                this.ProjBall = null;
                this.Bomerang = null;
                this.ProjArrow = null;
                this.HookshotPic = null;
                this.HookTarget = null;
                this.Sign = null;
                this.Triforce = null;
                if (NotIntro) {
                    p.HookshotPic = null;
                }
                this.Const = null;
                this.Flowers = null;
                this.Waterfall1 = null;
                this.Waterfall2 = null;
                this.Net = null;
                this.Candle1 = null;
                this.Candle2 = null;
                this.Fence = null;
                this.Grave = null;
                this.Brygga = null;
                this.WandShot = null;
                this.Xsize = dis.readByte();
                this.Ysize = dis.readByte();
                TilesetTemp = dis.readByte();
                if (TilesetTemp != this.TileSet) {
                    this.BasePic = null;
                    this.TileSet = TilesetTemp;
                }
                this.TileMap = null;
                System.gc();
                System.out.println("Tile set " + this.TileSet);
                System.out.println("Xsize " + this.Xsize);
                System.out.println("Ysize " + this.Ysize);
                this.TileMap = new byte[this.Xsize * this.Ysize];
                int i = 0;
                while (i < this.Xsize * this.Ysize) {
                    this.TileMap[i] = dis.readByte();
                    ++i;
                }
                int NumberOfWarps = dis.readByte();
                if (NumberOfWarps > 0) {
                    int i2 = 0;
                    while (i2 < NumberOfWarps) {
                        WarpZone TempW = new WarpZone();
                        TempW.MapX = dis.readUnsignedByte();
                        TempW.MapY = dis.readUnsignedByte();
                        TempW.ToX = dis.readUnsignedByte();
                        TempW.ToY = dis.readUnsignedByte();
                        TempW.PosX = dis.readUnsignedByte();
                        TempW.PosY = dis.readUnsignedByte();
                        this.Warp.addElement(TempW);
                        System.out.println("Warp added " + Integer.toString(i2));
                        ++i2;
                    }
                    System.out.println("Warps = " + NumberOfWarps);
                }
                try {
                    if (this.BasePic == null) {
                        if (this.TileSet == 0) {
                            this.BasePic = Image.createImage((String)"/Images/ZeldaTileSet01.png");
                        }
                        if (this.TileSet == 1) {
                            this.BasePic = Image.createImage((String)"/Images/ZeldaTileSet02.png");
                        }
                        if (this.TileSet == 2) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish05.png");
                        }
                        if (this.TileSet == 3) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish01.png");
                        }
                        if (this.TileSet == 4) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish02.png");
                        }
                        if (this.TileSet == 5) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish03.png");
                        }
                        if (this.TileSet == 6) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish04.png");
                        }
                        if (this.TileSet == 7) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish06.png");
                        }
                        if (this.TileSet == 8) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish07.png");
                        }
                        if (this.TileSet == 9) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish08.png");
                        }
                        if (this.TileSet == 10) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish09.png");
                        }
                        if (this.TileSet == 11) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish10.png");
                        }
                        if (this.TileSet == 12) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish11.png");
                        }
                        if (this.TileSet == 13) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish12.png");
                        }
                        if (this.TileSet == 14) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish13.png");
                        }
                        if (this.TileSet == 15) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish14.png");
                        }
                        if (this.TileSet == 16) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish15.png");
                        }
                        if (this.TileSet == 17) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish16.png");
                        }
                        if (this.TileSet == 18) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish17.png");
                        }
                        if (this.TileSet == 19) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish18.png");
                        }
                        if (this.TileSet == 20) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish19.png");
                        }
                        if (this.TileSet == 21) {
                            this.BasePic = Image.createImage((String)"/Images/Zelda1Minish20.png");
                        }
                        System.out.println("Load image.. ");
                    }
                }
                catch (IOException e) {
                    System.out.println("error loadin Map img");
                    return false;
                }
                g.translate(-g.getTranslateX(), -g.getTranslateY());
                int y = 0;
                while (y < this.Ysize) {
                    int x = 0;
                    while (x < this.Xsize) {
                        int Temp = this.TileMap[y * this.Xsize + x] & 0x3F;
                        if (Temp == 0) {
                            g.translate(16, 0);
                        } else {
                            g.setClip(0, 0, 16, 16);
                            g.clipRect(0, 0, 16, 16);
                            int x2 = Temp & 3;
                            int y2 = Temp >> 2;
                            g.drawImage(this.BasePic, -(x2 << 4), -(y2 << 4), 0);
                            g.translate(16, 0);
                        }
                        ++x;
                    }
                    g.translate(-g.getTranslateX(), 16);
                    ++y;
                }
                int MonstersToLoad = NumberOfMonsters = dis.readByte();
                int i3 = 0;
                while (i3 < this.VisitedMaps.size()) {
                    VisitedMap TempMap = (VisitedMap)this.VisitedMaps.elementAt(i3);
                    if (TempMap != null && TempMap.Map == this.CurrentMapNumber && TempMap.World == this.CurrentWorldNumber) {
                        MonstersToLoad = TempMap.Monsters;
                    }
                    ++i3;
                }
                if (NumberOfMonsters > 0) {
                    System.out.println("NumberOfMonsters = " + NumberOfMonsters);
                    int i4 = 0;
                    while (i4 < NumberOfMonsters) {
                        int MonsterXPos = dis.readByte();
                        int MonsterYPos = dis.readByte();
                        System.out.println("MOnster X " + MonsterXPos + " MOnster Y " + MonsterYPos);
                        MonsterXPos *= 16;
                        MonsterYPos *= 16;
                        int MonsterType = dis.readUnsignedByte();
                        if (i4 < MonstersToLoad) {
                            Monster TempM = new Monster(this.GetMonsterGfx(MonsterType), MonsterXPos, MonsterYPos, 1, MonsterType);
                            this.Monsters.addElement(TempM);
                        }
                        ++i4;
                    }
                    this.Death = Image.createImage((String)"/Images/Death.png");
                }
                int NumberOfItems = dis.readByte();
                System.out.println("NumberOfItems = " + NumberOfItems);
                if (NumberOfItems > 0) {
                    System.out.println("NumberOfItems = " + NumberOfItems);
                    int i5 = 0;
                    while (i5 < NumberOfItems) {
                        int ItemXPos = dis.readByte();
                        int ItemYPos = dis.readByte();
                        int ItemType = dis.readUnsignedByte();
                        int ItemUid = dis.readUnsignedByte();
                        System.out.println("ItemXPos X " + (ItemXPos *= 16) + " ItemYPos Y " + (ItemYPos *= 16) + " ItemType " + ItemType + " ItemUid " + ItemUid);
                        Item TempI = new Item(this.GetItemGfx(ItemType), ItemType, ItemXPos, ItemYPos, ItemUid);
                        if (NotIntro) {
                            boolean Add = false;
                            if ((p.Uids01 & 1 << ItemUid) <= 0) {
                                Add = true;
                            }
                            if (ItemType == 128 || ItemType == 129) {
                                Add = (p.HeartUids01 & 1 << ItemUid) <= 0;
                            }
                            if (ItemType == 131) {
                                Add = (p.UidKeys & 1 << ItemUid) <= 0;
                            }
                            if (ItemType == 147 || ItemType == 148 || ItemType == 149) {
                                Add = (p.UidRupies & 1 << ItemUid) <= 0;
                            }
                            if (Add) {
                                this.Items.addElement(TempI);
                            }
                        } else {
                            this.Items.addElement(TempI);
                        }
                        ++i5;
                    }
                }
                int NumberOfEvents = dis.readByte();
                System.out.println("NumberOfEvents = " + NumberOfEvents);
                if (NumberOfEvents > 0) {
                    System.out.println("NumberOfEvents = " + NumberOfEvents);
                    int i6 = 0;
                    while (i6 < NumberOfEvents) {
                        int EventGfx = dis.readUnsignedByte();
                        int EventGfxIndex = dis.readUnsignedByte();
                        int StringIndex = dis.readUnsignedByte();
                        int EventXPos = dis.readByte();
                        int EventYPos = dis.readByte();
                        int EventUid = dis.readUnsignedByte();
                        int TriggerValue = dis.readUnsignedByte();
                        int Res2 = dis.readUnsignedByte();
                        EventXPos *= 16;
                        EventYPos *= 16;
                        int Flags1 = dis.readUnsignedByte();
                        int Flags2 = dis.readUnsignedByte();
                        System.out.println(" Flags1 " + Flags1 + " Flags2 " + Flags2);
                        Event TempE = new Event(EventGfx);
                        TempE.Active = true;
                        TempE.TriggerValue = TriggerValue;
                        TempE.PosX = EventXPos;
                        TempE.PosY = EventYPos + 32;
                        TempE.GfxType = EventGfx;
                        TempE.StringIndex = StringIndex;
                        TempE.EventUid = EventUid;
                        TempE.Layer = Flags1 & 3;
                        TempE.Solid = (Flags1 & 4) > 0;
                        TempE.Destroy = (Flags1 & 8) > 0;
                        TempE.Sword = (Flags1 & 0x10) > 0;
                        TempE.Fire = (Flags1 & 0x20) > 0;
                        TempE.Bomb = (Flags1 & 0x40) > 0;
                        TempE.Key = (Flags1 & 0x80) > 0;
                        TempE.Monsters = (Flags2 & 1) > 0;
                        TempE.Graphical = (Flags2 & 2) > 0;
                        TempE.Text = (Flags2 & 0xC) >> 2;
                        TempE.Push = (Flags2 & 0x10) > 0;
                        TempE.Lift = Flags2 & 0x20;
                        TempE.Trigger = (byte)((Flags2 & 0xC0) >> 6);
                        if (TempE.Trigger == 3 && TempE.GfxType == 0) {
                            TempE.Trigger = 0;
                        }
                        if (TempE.GfxType > 0) {
                            if (TempE.GfxType != 17 || TempE.GfxType != 18) {
                                TempE.Gfx = this.GetEventGfx(TempE.GfxType);
                                TempE.Graphical = true;
                            } else {
                                TempE.Graphical = false;
                            }
                        }
                        boolean AddEvent = true;
                        int Tempint = EventUid / 32;
                        int TempUid = EventUid % 32;
                        System.out.println("TempE.GfxType " + TempE.GfxType + " TempE.Trigger " + TempE.Trigger);
                        System.out.println("Tempint " + Tempint + "EventUid " + EventUid);
                        System.out.println("Text Mode = " + TempE.Text);
                        if (NotIntro && TempE.EventUid != 0) {
                            if (CurrentWorld == 0 && (p.EventUid_0[Tempint] & 1 << TempUid) > 0) {
                                AddEvent = false;
                                System.out.println("Skipped Loading Event");
                            }
                            if (CurrentWorld == 1 && (p.EventUid_1[Tempint] & 1 << TempUid) > 0) {
                                AddEvent = false;
                                System.out.println("Skipped Loading Event");
                            }
                            if (CurrentWorld == 3 && (p.EventUid_3[Tempint] & 1 << TempUid) > 0) {
                                AddEvent = false;
                                System.out.println("Skipped Loading Event");
                            }
                            if (CurrentWorld == 4 && (p.EventUid_4[Tempint] & 1 << TempUid) > 0) {
                                AddEvent = false;
                                System.out.println("Skipped Loading Event");
                            }
                            if (CurrentWorld == 5 && (p.EventUid_5[Tempint] & 1 << TempUid) > 0) {
                                AddEvent = false;
                                System.out.println("Skipped Loading Event");
                            }
                            if (CurrentWorld == 6 && (p.EventUid_6[Tempint] & 1 << TempUid) > 0) {
                                AddEvent = false;
                                System.out.println("Skipped Loading Event");
                            }
                            if (CurrentWorld == 7 && (p.EventUid_7[Tempint] & 1 << TempUid) > 0) {
                                AddEvent = false;
                                System.out.println("Skipped Loading Event");
                            }
                            if (CurrentWorld == 8 && (p.EventUid_8[Tempint] & 1 << TempUid) > 0) {
                                AddEvent = false;
                                System.out.println("Skipped Loading Event");
                            }
                            if (CurrentWorld == 9 && (p.EventUid_9[Tempint] & 1 << TempUid) > 0) {
                                AddEvent = false;
                                System.out.println("Skipped Loading Event");
                            }
                            if (CurrentWorld == 10 && (p.EventUid_10[Tempint] & 1 << TempUid) > 0) {
                                AddEvent = false;
                                System.out.println("Skipped Loading Event");
                            }
                            if (CurrentWorld == 11 && (p.EventUid_11[Tempint] & 1 << TempUid) > 0) {
                                AddEvent = false;
                                System.out.println("Skipped Loading Event");
                            }
                        }
                        if (AddEvent) {
                            if (TempE.Layer <= 1) {
                                this.Events.addElement(TempE);
                                System.out.println("Event Added");
                            } else {
                                this.EventsLevel2.addElement(TempE);
                                System.out.println("Eventlevel2 Added");
                            }
                        }
                        ++i6;
                    }
                }
                int NumberOfStrings = dis.readByte();
                System.out.println("NumberOfStrings = " + NumberOfStrings);
                if (NumberOfStrings > 0) {
                    System.out.println("NumberOfStrings = " + NumberOfStrings);
                    int i7 = 0;
                    while (i7 < NumberOfStrings) {
                        int Strlen = dis.readUnsignedByte();
                        System.out.println("Strlen = " + Strlen);
                        char[] Temp = new char[Strlen + 1];
                        int j = 0;
                        while (j < Strlen) {
                            Temp[j] = (char)dis.readUnsignedByte();
                            ++j;
                        }
                        String str = new String(Temp);
                        this.Strings.addElement(str);
                        System.out.println(str);
                        ++i7;
                    }
                }
            } else {
                return false;
            }
            System.out.println("Done loading mapp");
            return true;
        }
        catch (IOException e) {
            System.out.println("File Not Found");
            return true;
        }
    }

    void Loadingmess(Graphics g2, int x) {
        int y = 9;
        g2.setClip(0, 0, this.ScreenWidth, this.ScreenHeight);
        g2.clipRect(0, 0, this.ScreenWidth, this.ScreenHeight);
        g2.translate(-g2.getTranslateX(), -g2.getTranslateY());
        g2.setColor(0);
        g2.fillRect(this.ScreenWidth / 2 - 48, this.ScreenHeight / 2 - 16, 96, 64);
        g2.translate(this.ScreenWidth / 2 - 32, this.ScreenHeight / 2 + 8);
        g2.setColor(0xFFFFFF);
        g2.drawString("Loading.. ", 0, 0, 0x10 | 4);
        g2.drawLine(this.ScreenWidth / 2 - 48 + 5, this.ScreenHeight / 2 + 16, x * y, this.ScreenHeight / 2 + 16);
        System.out.println("Load " + x);
    }

    void Saveingmess(Graphics g2, int x, int w, int h, int frame) {
        int y = 9;
        g2.translate(-g2.getTranslateX(), -g2.getTranslateY());
        g2.setColor(0xAAAAAA);
        g2.fillRect(w / 2 - 50, h / 2 - 18, 98, 66);
        g2.setColor(0);
        g2.fillRect(w / 2 - 48, h / 2 - 16, 96, 64);
        g2.translate(w / 2 - 32, h / 2 + 8);
        g2.setColor(0xFFFFFF);
        if ((frame >> 1) % 3 == 0) {
            g2.drawString("Saving ", 0, 0, 0x10 | 4);
        }
        if ((frame >> 1) % 3 == 1) {
            g2.drawString("Saving.. ", 0, 0, 0x10 | 4);
        }
        if ((frame >> 1) % 3 == 2) {
            g2.drawString("Saving.... ", 0, 0, 0x10 | 4);
        }
    }
}

